using Serilog;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Xunit;

namespace Bailun.ServiceFabric.Trace.Test
{
    public class LogStructTest
    {
        public LogStructTest()
        {
            Serilog.Debugging.SelfLog.Enable(msg => Debug.WriteLine(msg));
            Serilog.Log.Logger = new LoggerConfiguration()
              .MinimumLevel.Debug()
              .WriteTo.Debug()
              .WriteTo.Console()
              .CreateLogger();
        }

        [Fact]
        public void SimpleValue_Test()
        {
            var count = 456;
            Serilog.Log.Information("Retrieved {Count} records", count);
        }


        [Fact]
        public void Collection_Test()
        {
            var fruit = new[] { "Apple", "Pear", "Orange" };
            Serilog.Log.Information("In my bowl I have {Fruit}", fruit);
            Serilog.Log.CloseAndFlush();
        }


        [Fact]
        public void DictionaryWithSimpleValueKey_Test()
        {
            var fruit = new Dictionary<string, int> { { "Apple", 1 }, { "Pear", 5 } };
            Serilog.Log.Information("In my bowl I have {Fruit}", fruit);
        }

        [Fact]
        public void DictionaryWithObjectKey_Test()
        {
            var fruit = new Dictionary<Fruit, int> { { new Fruit { Name = "Apple" }, 1 }, { new Fruit { Name = "Pear" }, 5 } };
            Serilog.Log.Information("In my bowl I have {Fruit}", fruit);
        }
    }


    public class Fruit
    {
        public string Name { get; set; }
    }
}
