﻿using Microsoft.AspNetCore.Http;
using Serilog;
using Serilog.Events;
using System;

namespace Bailun.ServiceFabric.Trace.Middlewares
{
    /// <summary>
    /// Contains options for the <see cref="Serilog.AspNetCore.RequestLoggingMiddleware"/>.
    /// </summary>
    public class RequestLoggingOptions
    {
        /// <summary>
        /// Gets or sets the message template. The default value is
        /// <c>"HTTP {RequestMethod} {RequestPath} responded {StatusCode} in {Elapsed:0.0000} ms"</c>. The
        /// template can contain any of the placeholders from the default template, names of properties
        /// added by ASP.NET Core, and names of properties added to the <see cref="IDiagnosticContext"/>.
        /// </summary>
        /// <value>
        /// The message template.
        /// </value>
        public string MessageTemplate { get; set; }

        /// <summary>
        /// A function returning the <see cref="LogEventLevel"/> based on the <see cref="HttpContext"/>, the number of
        /// elapsed milliseconds required for handling the request, and an <see cref="Exception" /> if one was thrown.
        /// The default behavior returns <see cref="LogEventLevel.Error"/> when the response status code is greater than 499 or if the
        /// <see cref="Exception"/> is not null.
        /// </summary>
        /// <value>
        /// A function returning the <see cref="LogEventLevel"/>.
        /// </value>
        public Func<HttpContext, double, Exception, LogEventLevel> GetLevel { get; set; }

        /// <summary>
        /// A callback that can be used to set additional properties on the request completion event.
        /// </summary>
        public Action<IDiagnosticContext, HttpContext> EnrichDiagnosticContext { get; set; }

        internal RequestLoggingOptions() { }
    }
}
