﻿using Bailun.ServiceFabric.Trace;
using Serilog.Context;

namespace Microsoft.Extensions.Logging
{
    public static class MicroLoggerExtensions
    {
        /// <summary>
        /// 添加属性
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <param name="destructureObjects">复杂类型设置为false,则调用ToString()</param>
        /// <returns></returns>
        public static ILogger AddProperty(this ILogger logger, string name, object value, bool destructureObjects = false)
        {
            LogContext.PushProperty(name, value, destructureObjects);
            return logger;
        }
        /// <summary>
        /// 设置全局追踪Id
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="value">全局追踪Id</param>
        /// <returns></returns>
        public static ILogger SetTraceId(this ILogger logger, string value)
        {
            LogContext.PushProperty(Constants.TraceIdPropertyName, value);
            return logger;
        }

        /// <summary>
        /// 设置业务Id
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="value">业务Id</param>
        /// <returns></returns>
        public static ILogger SetBussinessId(this ILogger logger, string value)
        {
            LogContext.PushProperty(Constants.BusinessIdPropertyName, value);
            return logger;
        }

        /// <summary>
        /// 设置模块名称
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="value">模块名称</param>
        /// <returns></returns>
        public static ILogger SetModule(this ILogger logger, string value)
        {
            LogContext.PushProperty(Constants.ModulePropertyName, value);
            return logger;
        }

        /// <summary>
        /// 设置用户信息
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="userId">用户Id</param>
        /// <param name="userName">用户名</param>
        /// <returns></returns>
        public static ILogger SetIdentity(this ILogger logger, string userId, string userName = null)
        {
            LogContext.PushProperty(Constants.UserIdPropertyName, userId);

            if (!string.IsNullOrWhiteSpace(userName))
            {
                LogContext.PushProperty(Constants.UserNamePropertyName, userName);
            }
            return logger;
        }

        /// <summary>
        /// 设置标签
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="tags">标签...</param>
        /// <returns></returns>
        public static ILogger SetTags(this ILogger logger, params string[] tags)
        {
            LogContext.PushProperty(Constants.TagsPropertyName, tags);
            return logger;
        }

    }
}
