﻿using System;
using Microsoft.Extensions.DependencyInjection;
using SkyApm;
using SkyApm.Utilities.DependencyInjection;

namespace Bailun.Diagnostics.HttpClient
{
    public static class SkyWalkingBuilderExtensions
    {
        public static SkyApmExtensions AddHttpClient(this SkyApmExtensions extensions)
        {
            if (extensions == null)
            {
                throw new ArgumentNullException(nameof(extensions));
            }

            extensions.Services.AddSingleton<ITracingDiagnosticProcessor, HttpClientTracingDiagnosticProcessor>();
            
            return extensions;
        }
    }
}