﻿using Bailun.Diagnostics.AspNetCore;
using Bailun.Diagnostics.HttpClient;
using Bailun.ServiceFabric.Trace;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.DependencyInjection.Extensions;
using SkyApm;


[assembly: HostingStartup(typeof(SkyApmHostingStartup))]
namespace Bailun.ServiceFabric.Trace
{
    internal class SkyApmHostingStartup : IHostingStartup
    {
        public void Configure(IWebHostBuilder builder)
        {
            builder.ConfigureServices(services =>
            {
                services.Replace(ServiceDescriptor.Singleton<ITracingDiagnosticProcessor, HostingTracingDiagnosticProcessor>());

                services.Replace(ServiceDescriptor.Singleton<ITracingDiagnosticProcessor, HttpClientTracingDiagnosticProcessor>());
            });
        }
    }
}
