using System.Collections;
using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Http;
using SkyApm.Tracing;

namespace Bailun.Diagnostics.AspNetCore
{
    public class HttpRequestCarrierHeaderCollection : ICarrierHeaderCollection
    {
        private readonly IEnumerable<KeyValuePair<string, string>> _headers;

        public HttpRequestCarrierHeaderCollection(HttpRequest httpRequest)
        {
            _headers = httpRequest.Headers.Select(x => new KeyValuePair<string, string>(x.Key, x.Value)).ToArray();
        }

        public IEnumerator<KeyValuePair<string, string>> GetEnumerator()
        {
            return _headers.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return _headers.GetEnumerator();
        }

        public void Add(string key, string value)
        {
            throw new System.NotImplementedException();
        }
    }
}