﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.ServiceFabric.Trace
{
    public class Constants
    {
        #region 环境变量

        public const string Env_Skywalking_TraceIgnorePath = "SKYWALKING_TRACEIGNOREPATH";

        #endregion

        /// <summary>
        /// 全局追踪Id
        /// </summary>
        public const string TraceIdPropertyName = "TraceId";

        /// <summary>
        /// 业务Id
        /// </summary>
        public const string BusinessIdPropertyName = "BusinessId";

        /// <summary>
        /// 模块名称
        /// </summary>
        public const string ModulePropertyName = "Module";

        /// <summary>
        /// 标签前缀
        /// </summary>
        public const string TagsPropertyName = "Tags";

        /// <summary>
        /// 用户Id
        /// </summary>
        public const string UserIdPropertyName = "UserId";

        /// <summary>
        /// 用户名称
        /// </summary>
        public const string UserNamePropertyName = "UserName";

        /// <summary>
        /// Http请求体
        /// </summary>
        public const string RequestBodyPropertyName = "RequestBody";

        /// <summary>
        /// Http响应体
        /// </summary>
        public const string ResponseBodyPropertyName = "ResponseBody";

    }


    //
    // 摘要:
    //     Specifies the media type information for an email message attachment.
    public static class MediaTypeNames
    {
        //
        // 摘要:
        //     Specifies the kind of application data in an email message attachment.
        public static class Application
        {
            public const string Json = "application/json";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Application data is not interpreted.
            public const string Octet = "application/octet-stream";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Application data is in Portable
            //     Document Format (PDF).
            public const string Pdf = "application/pdf";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Application data is in Rich
            //     Text Format (RTF).
            public const string Rtf = "application/rtf";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Application data is a SOAP
            //     document.
            public const string Soap = "application/soap+xml";
            public const string Xml = "application/xml";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Application data is compressed.
            public const string Zip = "application/zip";
        }
        //
        // 摘要:
        //     Specifies the type of image data in an email message attachment.
        public static class Image
        {
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Image data is in Graphics Interchange
            //     Format (GIF).
            public const string Gif = "image/gif";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Image data is in Joint Photographic
            //     Experts Group (JPEG) format.
            public const string Jpeg = "image/jpeg";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Image data is in Tagged Image
            //     File Format (TIFF).
            public const string Tiff = "image/tiff";
        }
        //
        // 摘要:
        //     Specifies the type of text data in an email message attachment.
        public static class Text
        {
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Text data is in HTML format.
            public const string Html = "text/html";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Text data is in plain text
            //     format.
            public const string Plain = "text/plain";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Text data is in Rich Text Format
            //     (RTF).
            public const string RichText = "text/richtext";
            //
            // 摘要:
            //     Specifies that the System.Net.Mime.MediaTypeNames.Text data is in XML format.
            public const string Xml = "text/xml";
        }
    }
}
