﻿using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using Serilog;
using SkyApm.Tracing;
using System;
using System.Threading.Tasks;

namespace Bailun.ServiceFabric.Trace.Middlewares
{
    class TraceLoggingMiddleware
    {
        readonly RequestDelegate _next;
        public TraceLoggingMiddleware(RequestDelegate next)
        {
            _next = next;
        }

        public async Task Invoke(HttpContext httpContext)
        {
            if (httpContext == null) throw new ArgumentNullException(nameof(httpContext));

            string uid;

            var entrySegmentContextAccessor = httpContext.RequestServices.GetService<IEntrySegmentContextAccessor>();

            if (entrySegmentContextAccessor?.Context != null)
            {
                uid = entrySegmentContextAccessor.Context.TraceId.ToString();
            }
            else
            {
                uid = Guid.NewGuid().ToString("N");
            }

            Serilog.Log.Logger.SetTraceId(uid);

            await _next(httpContext);
        }
    }
}
