﻿using Microsoft.AspNetCore.Http;
using Serilog;
using SkyApm.Tracing;
using System;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using Microsoft.Extensions.DependencyInjection;

namespace Bailun.ServiceFabric.Trace.Middlewares
{
    class TraceLoggingMiddleware
    {
        readonly RequestDelegate _next;
        public TraceLoggingMiddleware(RequestDelegate next)
        {
            _next = next;
        }

        public async Task Invoke(HttpContext httpContext)
        {
            if (httpContext == null) throw new ArgumentNullException(nameof(httpContext));

            var uid = string.Empty;
            if (httpContext.Request.Headers.ContainsKey(Constants.TraceIdPropertyName))
            {
                uid = httpContext.Request.Headers[Constants.TraceIdPropertyName];
            }
            else
            {
                var entrySegmentContextAccessor = httpContext.RequestServices.GetService<IEntrySegmentContextAccessor>();

                if (entrySegmentContextAccessor?.Context != null)
                {
                    uid = entrySegmentContextAccessor.Context.TraceId.ToString();
                }
                else
                {
                    uid = Guid.NewGuid().ToString("N");
                }
            }

            if (httpContext.Items.ContainsKey(Constants.TraceIdPropertyName))
            {
                httpContext.Items[Constants.TraceIdPropertyName] = uid;
            }
            else
            {
                httpContext.Items.Add(Constants.TraceIdPropertyName, uid);
            }

            Serilog.Log.Logger.SetTraceId(uid);

            await _next(httpContext);

            ////认证通过
            //if (httpContext.User.Identity.IsAuthenticated && httpContext.User?.Claims != null && httpContext.User.Claims.Any())
            //{
            //    Serilog.Log.Logger.SetIdentity(
            //        httpContext.User.FindFirst(ClaimTypes.NameIdentifier)?.Value,
            //        httpContext.User.Identity.Name);
            //}
        }
    }
}
