using Microsoft.Extensions.Hosting;
using Serilog;
using SimpleConsole.MicroServices;
using SkyApm.Tracing;
using SkyApm.Tracing.Segments;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace SimpleConsole
{
    public class Worker : BackgroundService
    {
        private readonly IUserApi _userApi;
        private readonly ITracingContext _tracingContext;
        public Worker(IUserApi userApi, ITracingContext tracingContext)
        {
            _userApi = userApi;
            _tracingContext = tracingContext;
        }

        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            await Task.Delay(3000);
            var index = 1;
            while (!stoppingToken.IsCancellationRequested && index < 5)
            {
                var context = _tracingContext.CreateEntrySegmentContext(nameof(ExecuteAsync), new TextCarrierHeaderCollection(new Dictionary<string, string>()));

                Log.Logger.SetTraceId(context.TraceId.ToString());

                await Task.Delay(1000, stoppingToken);



                //todo ҵ߼
                await _userApi.GetAsync(index.ToString());
                Log.Logger.Information($"{index}ε............... ");
                index++;


                context.Span.AddLog(LogEvent.Message($"Worker running at: {DateTime.Now}"));

                _tracingContext.Release(context);
            }
        }
    }
}
