# 日志组件

## 一、集成方法

1. **AspNetCore** 配置

    - `Startup.cs`

        ``` C#

        public void Configure(IApplicationBuilder app, ILoggerFactory loggerFactory, IApiInfo apiInfo)
        {
            app.UseSerilogTraceLogging(); //使用日志跟踪中间件,注意顺序，必须是第一个
            app.UseAbpService(_appConfiguration, loggerFactory, apiInfo);
        }
        ```

    - `Program.cs`

        ``` C#
        public class Program
        {
            public static void Main(string[] args)
            {
                CreateWebHostBuilder(args).Build().Run();
            }

            public static IWebHostBuilder CreateWebHostBuilder(string[] args) =>
                WebHost.CreateDefaultBuilder(args)
                    .UseStartup<Startup>()
                    .UseSerilog(true, true);//注入 SerilogFactory
        }

        ```

1. **Console** 配置

    - `Program.cs`

1. **appsettings.json**

    1. 移除所有 `Microsoft.Extension.logging.ILogger` 的配置

    1. 添加 `Serilog` 、`Exceptionless` 的配置 

    ``` json
    {
      //"Logging": {
      //  "LogLevel": {
      //    "Default": "Debug",
      //    "System": "Information",
      //    "Microsoft": "Information"
      //  }
      //}
      "Serilog": {
          "MinimumLevel": {
          "Default": "Information",
          "Override": {
              "Microsoft": "Warning",
              "System": "Warning"
          }
          }
      },
      "Exceptionless": {
          "ApiKey": "hrOhVo64hIntQGW5D51PCm2wRlLw2z2VEhSKtZ6U",
          "ServerUrl": "http://log.bailuntec.com/"
      }
    }
    ```

## 二、常用日志级别

| 级别 | 描述 |
| :--- | :--- |
| Debug | 有关在开发和调试中可能有用的信息 |
| Information | 用于跟踪应用，比如业务埋点信息 |
| Warning  | 异常或意外事件，包括不会中断应用运行但仍需调查的错误 |
| Error  | 表示无法处理的错误和异常，这些消息指示的是当前活动或操作（例如当前 HTTP 请求）中的失败，而不是整个应用中的失败 |

## 三、使用方法

1. 注入方式

    1. `Serilog.Log` 静态方法

        ``` C#

        //这里扩展的属性全都展示在 Exceptionless 日志详情的 Extended Data 
        Serilog.Log.Logger.ForContext(typeof(StockController))
                .SetModule("库存管理")
                .SetBussinessId("ware123sku456")
                .SetTags("stock", "incr", "action")
                .AddProperty("CustomProperty1", "CustomValue1")
                .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 })
                .Information("Disk quota {Quota} MB exceeded by {Broker}", 12, "RabbitMQ");

        Serilog.Log.Logger.Information("{BusinessId} ......");
        ```

    1. 构造器注入

        ``` C#
        namespace SimpleApi.Controllers
        {
            [Route("api/[controller]")]
            [ApiController]
            public class ValuesController : ControllerBase
            {
                Microsoft.Extensions.Logging.ILogger _logger;
                public ValuesController(Microsoft.Extensions.Logging.ILogger<ValuesController> logger)
                {
                    _logger = logger;

                }

                // GET api/values
                [HttpGet]
                public ActionResult<IEnumerable<string>> Get([FromServices] IUserApi userApi)
                {
                    _logger
                        .SetModule("库存管理")
                        .SetBussinessId("ware123sku456")
                        .SetTags("stock", "incr", "action")
                        .AddProperty("CustomProperty1", "CustomValue1")
                        .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 })
                        .LogInformation("Microsoft Logger ....");

                    return new string[] { "value1", "value2" };
                }
            }
        }

        ```

1. 输出格式化

    - 值对象，直接输出值。 包括以下：

        - Booleans - bool
        - Numerics - byte, short, ushort, int, uint, long, ulong, float, double, decimal
        - Strings - string, byte[]
        - Temporals - DateTime, DateTimeOffset, TimeSpan
        - Others - Guid, Uri
        - Nullables - nullable versions of any of the types above

        > 如下示例，打印结果为： `Retrieved 456 records`

        ``` C#
        var count = 456;
        Log.Information("Retrieved {Count} records", count);
        ```

    - 集合，继承自 `IEnumerable`

        > 如下示例，打印结果为： `In my bowl I have ["Apple","Pear","Orange"]`

        ``` C#
        var fruit = new[] { "Apple", "Pear", "Orange" };
        Log.Information("In my bowl I have {Fruit}", fruit);
        ```

    - Dictionary，继承自 `IEnumerable`, Key 类型为值类型

        > 如下示例，打印结果为： `In my bowl I have {"Apple":1,"Pear":5}`

        ``` C#
        var fruit = new Dictionary<string, int> { { "Apple", 1 }, { "Pear", 5 } };
        Log.Information("In my bowl I have {Fruit}", fruit);
        ```

    - Dictionary，继承自 `IEnumerable`, Key 类型为复杂类型

        > 如下示例，打印结果为： `In my bowl I have ["[Bailun.ServiceFabric.Trace.Test.Fruit, 1]","[Bailun.ServiceFabric.Trace.Test.Fruit, 5]"]`

        ``` C#
        var fruit = new Dictionary<Fruit, int> { { new Fruit { Name = "Apple" }, 1 }, { new Fruit { Name = "Pear" }, 5 } };
        Log.Information("In my bowl I have {Fruit}", fruit);
        ```

## 四、`Exceptionless`

1. Demo

    ``` C#
    Serilog.Log.Logger.ForContext(typeof(StockController))
        .SetModule("库存管理")  //扩展属性 Module
        .SetBussinessId("ware123sku456") //扩展属性 BusinessId
        .SetTags("stock", "incr", "action") //Tag
        .AddProperty("CustomProperty1", "CustomValue1") //自定义扩展属性 CustomProperty1
        .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 }) //自定义扩展属性 CustomProperty2
        .Information("Disk quota {Quota} MB exceeded by {Broker}", 12, "RabbitMQ"); //自定义扩展属性 Quota 、Broker
    ```

1. 扩展属性

    > 扩展的属性全都展示在 Exceptionless 日志详情的 Extended Data，Exceptionless 会给属性加上索引，方便检索。以下两种方式添加自定义扩展属性

    - `AddProperty` 扩展方法：

        ``` C#
        Serilog.Log.Logger
            .AddProperty("CustomProperty1", "CustomValue1") //自定义扩展属性 CustomProperty1
            .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 }) //自定义扩展属性 CustomProperty2
        ```

    - 格式化输出：

        ``` C#
        Serilog.Log.Logger.Information("Disk quota {Quota} MB exceeded by {Broker}", 12, "RabbitMQ"); //自定义扩展属性 Quota 、Broker
        ```

1. 检索

    > Exceptionless 支持 Key:Value 格式检索

    ``` C#
    //标签
    tag:"stock" or tag:sku

    //自定义扩展属性
    data.businessid:ware123sku456
    data.traceid:f3fcc704ff994622a0ec2c84e4aeb578
    ```

    ![search](./exceptionless-search.png)

## 五、使用 `APM` 扩展日志 —— `SkyWalking`

1. 客户端

    - SkyAPM.Agent.AspNetCore
    - SkyAPM.Agent.GeneralHost
    - SkyAPM.Agent.AspNet

1. 配置

    1. 安装 `SkyAPM.DotNet.CLI`

        ``` bash
        dotnet tool install -g SkyAPM.DotNet.CLI
        ```

    1. 使用命令生成配置文件：`dotnet skyapm config [your_service_name] [your_servers]`

        ``` bash
        dotnet skyapm config sample_app 192.168.0.1:11800
        ```

    > **特别注意：** 配置文件 `skyapm.json` 复制属性 更改为 `始终复制` 或 `较新则复制`

1. 使用方法

    - 通过环境变量 `ASPNETCORE_HOSTINGSTARTUPASSEMBLIES=SkyAPM.Agent.AspNetCore` 配置 `Aspnetcore` 客户端的入口程序集

    - 通过环境变量 `SKYWALKING__SERVICENAME=sample_app` 配置服务名称，不配置则使用 `skyapm.json` 的 `ServiceName`

1. 自定义 `Diagnostic` 上传跟踪信息
