﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Bailun.ServiceFabric.Trace
{
    public class TracePathFilter
    {
        static string[] DefaultFilterPatterns = new string[]
        {
            @"log\.bailuntec\.com.*", //过滤exceptionless 上报
            @"/status$", //健康心跳检测
            @"v1/kv/.*", //Consul DNS
            @"swagger/.*" //swagger 文档
        };
        /// <summary>
        /// 是否忽略追踪路由
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static bool IsIgnore(string path)
        {
            var patterns = Environment
                .GetEnvironmentVariable(Constants.Env_Skywalking_TraceIgnorePath)
                ?.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries) ?? new string[] { };

            patterns = DefaultFilterPatterns.Union(patterns).ToArray();

            return patterns.Any(p => Regex.IsMatch(path, p, RegexOptions.IgnoreCase));
        }
    }
}
