﻿using Bailun.ServiceFabric.Trace.Middlewares;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Serilog;
using Serilog.AspNetCore;
using System;
using System.IO;
using System.Text;
using Microsoft.AspNetCore.Http.Internal;

namespace Microsoft.AspNetCore.Builder
{
    public static class ApplicationBuilderExtensions
    {
        /// <summary>
        /// Adds middleware for streamlined request logging. Instead of writing HTTP request information
        /// like method, path, timing, status code and exception details
        /// in several events, this middleware collects information during the request (including from
        /// <see cref="IDiagnosticContext"/>), and writes a single event at request completion. Add this
        /// in <c>Startup.cs</c> before any handlers whose activities should be logged.
        /// </summary>
        /// <param name="app">The application builder.</param>
        /// <param name="messageTemplate">The message template to use when logging request completion
        /// events. The default is
        /// <c>"HTTP {RequestMethod} {RequestPath} responded {StatusCode} in {Elapsed:0.0000} ms"</c>. The
        /// template can contain any of the placeholders from the default template, names of properties
        /// added by ASP.NET Core, and names of properties added to the <see cref="IDiagnosticContext"/>.
        /// </param>
        /// <returns>The application builder.</returns>
        public static IApplicationBuilder UseBailunRequestLogging(
            this IApplicationBuilder app,
            string messageTemplate)
            => app.UseBailunRequestLogging(opts => opts.MessageTemplate = messageTemplate);

        /// <summary>
        /// Adds middleware for streamlined request logging. Instead of writing HTTP request information
        /// like method, path, timing, status code and exception details
        /// in several events, this middleware collects information during the request (including from
        /// <see cref="IDiagnosticContext"/>), and writes a single event at request completion. Add this
        /// in <c>Startup.cs</c> before any handlers whose activities should be logged.
        /// </summary>
        /// <param name="app">The application builder.</param>
        /// <param name="configureOptions">A <see cref="System.Action{T}" /> to configure the provided <see cref="RequestLoggingOptions" />.</param>
        /// <returns>The application builder.</returns>
        public static IApplicationBuilder UseBailunRequestLogging(
            this IApplicationBuilder app,
            Action<RequestLoggingOptions> configureOptions = null)
        {
            if (app == null) throw new ArgumentNullException(nameof(app));

            //Action<RequestLoggingOptions> configOptionsExtension = opt =>
            //{
            //    configureOptions?.Invoke(opt);

            //    var orginalEnrichDiagnosticContext = opt.EnrichDiagnosticContext;

            //    opt.EnrichDiagnosticContext = (diagnosticContext, httpContext) =>
            //    {
            //        orginalEnrichDiagnosticContext?.Invoke(diagnosticContext, httpContext);
            //        diagnosticContext.Set(Constants.RequestBodyPropertyName, StringExtension.GetBodyString(httpContext.Request));
            //    };
            //};
            return app.UseMiddleware<TraceLoggingMiddleware>()
                .UseSerilogRequestLogging(configureOptions);
        }
    }
}
