﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using SampleApi.MicroServices;
using Serilog;

namespace SimpleApi.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ValuesController : ControllerBase
    {
        Microsoft.Extensions.Logging.ILogger _logger;
        public ValuesController(Microsoft.Extensions.Logging.ILogger<ValuesController> logger)
        {
            _logger = logger;

        }
        // GET api/values
        [HttpGet]
        public IEnumerable<string> Get([FromServices] IUserApi userApi)
        {
            //_logger.LogInformation("Microsoft Logger ....");
            //_logger.SetModule("MicroLogger").LogInformation("Mircrosoft Logger ....");
            //Log.Logger.SetModule("Test").Information("{BusinessId} ......");
            //Log.Logger.SetModule("Test2").SetBussinessId("b1").Information("{BusinessId} ......");
            //Log.Logger.SetModule("Test2").Information("{BusinessId} ......");

            Serilog.Log.Logger.ForContext(typeof(ValuesController))
            .SetModule("库存管理")  //扩展属性 Module
            .SetBussinessId("ware123sku456") //扩展属性 BusinessId
            .SetTags("stock", "incr", "action") //Tag
            .AddProperty("CustomProperty1", "CustomValue1") //自定义扩展属性 CustomProperty1
            .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 }) //自定义扩展属性 CustomProperty2
            .Information("[api1] Disk quota {Quota} MB exceeded by {Broker}", 12, "RabbitMQ"); //自定义扩展属性 Quota 、Broker


            return userApi.GetAsync("dafadfdsfafd").InvokeAsync().GetAwaiter().GetResult();
        }

        // GET api/values/5
        [HttpGet("{id}")]
        public ActionResult<string> Get(int id)
        {
            return "value";
        }

        // POST api/values
        [HttpPost]
        public void Post([FromForm] string v1, [FromForm] string v2, [FromServices] IUserApi userApi)
        {
            userApi.PostAsync(v1, v2).InvokeAsync().GetAwaiter().GetResult();
        }

        // PUT api/values/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/values/5
        [HttpDelete("{id}")]
        public void Delete(int id)
        {
        }
    }
}
