﻿using Bailun.ServiceFabric.Trace;
using Microsoft.AspNetCore.Http;
using SkyApm.Tracing;

namespace Microsoft.Extensions.DependencyInjection
{
    public static class HttpClientBuilderExtensions
    {
        /// <summary>
        /// HttpClient配置扩展TraceId
        /// </summary>
        /// <param name="builder"></param>
        /// <returns></returns>
        public static IHttpClientBuilder ConfigureTraceHttpClient(this IHttpClientBuilder builder)
        {
            return builder.ConfigureHttpClient((sp, httpclient) =>
             {
                 var ctx = sp.GetService<IHttpContextAccessor>()?.HttpContext;

                 if (ctx != null)
                 {
                     if (ctx.Items.ContainsKey(Constants.TraceIdPropertyName))
                     {
                         httpclient.DefaultRequestHeaders.Add(
                             Constants.TraceIdPropertyName,
                             ctx.Items[Constants.TraceIdPropertyName].ToString());
                     }
                 }
             });
        }
    }
}
