﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using System;
using Bailun.ServiceFabric.Trace;
using Microsoft.Extensions.Hosting;

namespace Serilog
{
    public static class GenericHostBuilderExtensions
    {
        /// <summary>
        /// 日志配置
        /// </summary>
        /// <param name="builder"></param>
        /// <param name="writeToExceptionless">是否写到Exceptionless</param>
        /// <param name="writeToConsole">是否写到控制台</param>
        /// <param name="configureLogger">扩展配置</param>
        /// <returns></returns>
        public static IHostBuilder UseSerilog(this IHostBuilder builder, bool writeToExceptionless = false, bool writeToConsole = false, Action<LoggerConfiguration> configureLogger = null)
        {

            Action<HostBuilderContext, LoggerConfiguration> configure = (hostingContext, loggerConfiguration) =>
             {
                 loggerConfiguration
                     .ReadFrom.Configuration(hostingContext.Configuration)
                     .Enrich.FromLogContext();

                 if (writeToExceptionless)
                 {
                     var exceptionlessSection = hostingContext.Configuration.GetSection("Exceptionless");
                     var apiKey = exceptionlessSection.GetValue<string>("ApiKey");
                     var serverUrl = exceptionlessSection.GetValue<string>("ServerUrl");

                     loggerConfiguration.WriteTo.Exceptionless(apiKey, serverUrl);
                 }

                 if (hostingContext.HostingEnvironment.IsDevelopment())
                 {
                     loggerConfiguration.WriteTo.Debug();
                 }

                 if (writeToConsole)
                 {
                     loggerConfiguration
                         .WriteTo
                         .Console(outputTemplate: "[{Timestamp:HH:mm:ss} {Level:u3}] {TraceId:l} {Message:lj} {NewLine}{Exception}");
                 }
             };
            return builder.UseSerilog(configure);
        }
    }
}
