﻿using Serilog;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using WebApiClient.Attributes;
using WebApiClient.Contexts;

namespace Bailun.ServiceFabric.Trace.Attributes
{
    public class TraceInterceptAttribute : TraceFilterBaseAttribute
    {
        const string DefaultMessageTemplate =
            "HTTP {RequestMethod} {RequestPath} responded {StatusCode}{NewLine}" +
            "[REQUEST] {$RequestTime}{NewLine}" +
            "{$RequestHeaders}{NewLine}" +
            "{$RequestContent}{NewLine}" +
            "[RESPONSE] {$ResponseTime}{NewLine}" +
            "{$ResponseHeaders}{NewLine}" +
            "{$ResponseContent}";

        const string RequestMessageTemplate =
            "HTTP {RequestMethod} {RequestPath} responded 400 {NewLine}" +
            "[REQUEST] {RequestTime}{NewLine}" +
            "{RequestHeaders}{NewLine}" +
            "{RequestContent}";

        const string timeFormat = "yyyy-MM-dd HH:mm:ss.fff";

        public TraceInterceptAttribute() { }
        public TraceInterceptAttribute(string module)
        {
            this.Module = module;
        }
        public string Module { get; set; }
        protected override Task LogTraceMessageAsync(ApiActionContext context, TraceMessage traceMessage)
        {
            var method = context.ApiActionDescriptor.Member;
            var actionName = $"{method.DeclaringType.Name}.{method.Name}";

            var module = string.IsNullOrWhiteSpace(this.Module) ? actionName : this.Module;

            Serilog.Log.Logger.SetModule(module);

            var RequestTime = traceMessage.RequestTime.ToString(timeFormat);
            var ResponseTime = traceMessage.ResponseTime.ToString(timeFormat);
            if (traceMessage.Exception == null)
            {
                if (traceMessage.HasResponse)
                {
                    if (traceMessage.HasRequest)
                    {
                        Serilog.Log.Logger.Information(DefaultMessageTemplate,
                            context.RequestMessage.Method, context.RequestMessage.RequestUri.PathAndQuery, context.ResponseMessage.StatusCode, System.Environment.NewLine,

                            traceMessage.RequestTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.RequestHeaders, System.Environment.NewLine,
                            traceMessage.RequestContent, System.Environment.NewLine,
                            traceMessage.ResponseTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.ResponseHeaders, System.Environment.NewLine,
                            traceMessage.ResponseContent);
                    }


                }
                else if (traceMessage.HasRequest)
                {
                    Serilog.Log.Logger.Information(RequestMessageTemplate,
                        context.RequestMessage.Method, context.RequestMessage.RequestUri.PathAndQuery, context.ResponseMessage.StatusCode, System.Environment.NewLine,

                            traceMessage.RequestTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.RequestHeaders, System.Environment.NewLine,
                            traceMessage.RequestContent);
                }


            }
            else
            {
                if (traceMessage.HasResponse)
                {
                    if (traceMessage.HasRequest)
                    {
                        Serilog.Log.Logger.Error(traceMessage.Exception, DefaultMessageTemplate,
                            context.RequestMessage.Method, context.RequestMessage.RequestUri.PathAndQuery, context.ResponseMessage.StatusCode, System.Environment.NewLine,

                            traceMessage.RequestTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.RequestHeaders, System.Environment.NewLine,
                            traceMessage.RequestContent, System.Environment.NewLine,
                            traceMessage.ResponseTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.ResponseHeaders, System.Environment.NewLine,
                            traceMessage.ResponseContent);
                    }


                }
                else if (traceMessage.HasRequest)
                {
                    Serilog.Log.Logger.Error(traceMessage.Exception, RequestMessageTemplate,
                        context.RequestMessage.Method, context.RequestMessage.RequestUri.PathAndQuery, System.Environment.NewLine,

                            traceMessage.RequestTime.ToString(timeFormat), System.Environment.NewLine,
                            traceMessage.RequestHeaders, System.Environment.NewLine,
                            traceMessage.RequestContent);
                }
            }

            return Task.CompletedTask;
        }

    }
}
