﻿using Microsoft.Extensions.Configuration;
using Serilog;
using SimpleConsole.MicroServices;
using System;
using System.IO;
using System.Threading.Tasks;
using WebApiClient;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Configuration.EnvironmentVariables;
using SkyApm.Agent.GeneralHost;
using Microsoft.Extensions.DependencyInjection;
using SkyApm;
using Bailun.Diagnostics.HttpClient;
using System.Linq;
using Microsoft.Extensions.DependencyInjection.Extensions;

namespace SimpleConsole
{
    class Program
    {
        static void Main(string[] args)
        {
            var host = CreateHost(args);
            
            Log.Information("Getting the motors running...");
            
            host.Run();

        }

        static IHost CreateHost(string[] args) =>
            new HostBuilder()
            .UseContentRoot(Directory.GetCurrentDirectory())
            .ConfigureHostConfiguration(config =>
            {
                config.AddEnvironmentVariables(prefix: "DOTNET_");
                if (args != null)
                {
                    config.AddCommandLine(args);
                }
            })
            .ConfigureAppConfiguration((hostingContext, config) =>
            {
                var env = hostingContext.HostingEnvironment;

                config.AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                      .AddJsonFile($"appsettings.{env.EnvironmentName}.json", optional: true, reloadOnChange: true);

            })
            .AddSkyAPM()
            .ConfigureServices(services =>
            {
                services.AddHostedService<Worker>();
                services.AddHttpApi<IUserApi>(opt =>
                {
                    opt.HttpHost = new Uri("http://localhost:5000/");
                });

                services.Replace(ServiceDescriptor.Singleton<ITracingDiagnosticProcessor, HttpClientTracingDiagnosticProcessor>());
            })
            .UseSerilog(false, true)
            .Build();

    }
}
