# 日志使用

## 一、 配置

1. Program.cs 

    ``` C#
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateWebHostBuilder(args).Build().Run();
        }

        public static IWebHostBuilder CreateWebHostBuilder(string[] args) =>
            WebHost.CreateDefaultBuilder(args)
                .UseStartup<Startup>()
                .UseSerilog(true, true);//注入 SerilogFactory
    }

    ```

1. StartUp.cs

    ``` C#

    public void Configure(IApplicationBuilder app, ILoggerFactory loggerFactory, IApiInfo apiInfo)
    {
        app.UseSerilogTraceLogging(); //使用日志跟踪中间件,注意顺序，必须是第一个
        app.UseAbpService(_appConfiguration, loggerFactory, apiInfo);
    }
    ```

1. appsettings.json

    1. 移除所有 Microsoft.Extension.logging.ILogger 的配置

    1. 添加 Serilog 的配置

    ``` json
    {
      //"Logging": {
      //  "LogLevel": {
      //    "Default": "Debug",
      //    "System": "Information",
      //    "Microsoft": "Information"
      //  }
      //}
      "Serilog": {
          "MinimumLevel": {
          "Default": "Information",
          "Override": {
              "Microsoft": "Warning",
              "System": "Warning"
          }
          }
      },
      "Exceptionless": {
          "ApiKey": "hrOhVo64hIntQGW5D51PCm2wRlLw2z2VEhSKtZ6U",
          "ServerUrl": "http://log.bailuntec.com/"
      }
    }
    ```

## 二、使用

1. Demo

    ``` C#

    //这里扩展的属性全都展示在 Exceptionless 日志详情的 Extended Data 
    Log.Logger.ForContext(typeof(StockController))
            .SetModule("库存管理")
            .SetBussinessId("ware123sku456")
            .SetTags("stock", "incr", "action")
            .AddProperty("CustomProperty1", "CustomValue1")
            .AddProperty("CustomProperty2", new { Name = "Jack", Age = 18 })
            .Information("Disk quota {Quota} MB exceeded by {Broker}", 12, "RabbitMQ");

    Log.Logger.Information("{BusinessId} ......");
    ```

1. `Exceptionless` 检索

    > 自定义属性检索，自定义属性包括 module、traceid、businessid 等

        data.businessid:ware123sku456
        data.traceid:f3fcc704ff994622a0ec2c84e4aeb578 

    > [Exceptionless 检索相关文档](https://github.com/exceptionless/Exceptionless/wiki/Filtering-Searching)

![search](./doc/exceptionless-search.png)
