﻿using Bailun.Core.Service.Core.Configuration;
using Bailun.ServiceFabric.Core.ApiWidgets;
using Bailun.ServiceFabric.Exceptionless;
using Bailun.ServiceFabric.Extension;
using Bailun.ServiceFabric.MicroService;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.HttpOverrides;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;

namespace Bailun.Core.WebApiDemo.Startup
{
    public class AuthConfigurer
    {
        public static void Configure(IServiceCollection services, IConfiguration configuration)
        {
            //扩大接口能接收的post容量
            services.Configure<FormOptions>(options =>
            {
                options.ValueCountLimit = int.MaxValue; // 2000 items max
                options.ValueLengthLimit = 1024 * 1024 * 100; // 100MB max len form data
            });
            services.AddMvc().SetCompatibilityVersion(CompatibilityVersion.Version_2_1).AddMvcApiResult();
            //添加Exceptionless服务
            services.AddServiceExceptionless();
            services.Configure<ForwardedHeadersOptions>(options =>
            {
                options.ForwardedHeaders =
                    ForwardedHeaders.XForwardedFor | ForwardedHeaders.XForwardedProto;
            });
            services.AddSingleton(ApiInfo.Instantiate(configuration))
                .AddWebDbContext(configuration.GetConnectionString("Default"))
                .AddMicroService(configuration, ApiInfo.Instance);


            //网关地址
            //var hostUrl = configuration["GatewayAddress"];
            //var localApiUrl = configuration["AppSetting:LocalApiUrl"];
            //添加微服务
            //services.AddHttpClient<IMicroServiceApi>().AddTypedClient((client, p) =>
            //{
            //    var httpApiConfig = new HttpApiConfig(client)
            //    {
            //        HttpHost = new Uri(hostUrl),
            //        LoggerFactory = p.GetRequiredService<ILoggerFactory>()
            //    };
            //    return HttpApiClient.Create<IMicroServiceApi>(httpApiConfig);
            //});



            ConfigManagerConf.SetConfiguration(configuration);
        }
    }
}
