﻿using System;
using System.Collections.Generic;
using System.Reflection;
using Bailun.ServiceFabric.Core;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.WebApiDemo
{
    public class ApiInfo : IApiInfo
    {
        private ApiInfo(IConfiguration config)
        {
            AuthenticationAuthority = config["Authority"];
        }

        public string AuthenticationAuthority { get; }

        public string Title => "Api Test";

        public string Version => "v1";

        public Assembly ApplicationAssembly => GetType().Assembly;

        public IDictionary<string, string> Scopes => new Dictionary<string, string>
        {
            {"PublishApi", Title}
        };

        public SwaggerAuthInfo SwaggerAuthInfo => new SwaggerAuthInfo(
            "echoapiswaggerui", "", ""
            );

        public static IApiInfo Instantiate(IConfiguration config)
        {
            Instance = new ApiInfo(config);
            return Instance;
        }

        public static IApiInfo Instance { get; private set; }

        public string ApiName => "PublishApi";

        public string ApiSecret => "secret";

        public string BindAddress { get => throw new NotImplementedException(); set => throw new NotImplementedException(); }

        public int BindPort { get => throw new NotImplementedException(); set => throw new NotImplementedException(); }
    }
}
