﻿using System.Threading.Tasks;
using Abp.Threading.BackgroundWorkers;
using Bailun.Core.TaskJob.IBackgroudWorker;
using Hangfire;
using Hangfire.Server;

namespace Bailun.Core.TaskJob
{
    /// <summary>
    /// 所有后台工作者类都应继承该类
    /// </summary>
    [AutomaticRetry(Attempts = 0)]
    public abstract class BackgroundWorker<T> : BackgroundWorkerBase, IBackgroundWorkerDo where T : IBackgroundWorkerDo
    {
        protected readonly IBackgroudWorkerProxy _workProxy;
        protected readonly WorkerConfig _config;
        protected readonly int _countMany = 5000;
        protected readonly int _countMin = 3000;
        protected BackgroundWorker(IBackgroudWorkerProxy workProxy, WorkerConfig config)
        {
            _workProxy = workProxy;
            _config = config;
        }
        /// <summary>
        /// 任务启动
        /// </summary>
        public override void Start()
        {
            _workProxy.Excete<T>(DoWorkAsync(null).Wait, _config); //主要指定当前任务类，不然hangfire无法调用，不然可以移到父类去
        }

        public override void Stop()
        {
            base.Stop();
        }

        public override void WaitToStop()
        {
            base.WaitToStop();
        }

        /// <summary>
        /// 具体的任务执行
        /// </summary>
        public abstract Task DoWorkAsync(PerformContext context);
    }
}
