using Abp.Events.Bus;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Core;
using Bailun.Core.Core.Configuration;
using Bailun.Core.EntityFrameworkCore.EntityFrameworkCore;
using Bailun.Core.Migrator.DependencyInjection;
using Castle.MicroKernel.Registration;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.Migrator
{
    [DependsOn(typeof(BaseEntityFrameworkModule))]
    public class PublishMigratorModule : AbpModule
    {
        private readonly IConfigurationRoot _appConfiguration;

        public PublishMigratorModule(BaseEntityFrameworkModule abpProjectNameEntityFrameworkModule)
        {
            abpProjectNameEntityFrameworkModule.SkipDbSeed = true;

            _appConfiguration = AppConfigurations.Get(
                typeof(PublishMigratorModule).GetAssembly().GetDirectoryPathOrNull()
            );
        }

        public override void PreInitialize()
        {
            Configuration.DefaultNameOrConnectionString = _appConfiguration.GetConnectionString(
                ProductConsts.ConnectionStringName
            );

            Configuration.BackgroundJobs.IsJobExecutionEnabled = false;
            Configuration.ReplaceService(
                typeof(IEventBus), 
                () => IocManager.IocContainer.Register(
                    Component.For<IEventBus>().Instance(NullEventBus.Instance)
                )
            );
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(PublishMigratorModule).GetAssembly());
            ServiceCollectionRegistrar.Register(IocManager);
        }
    }
}
