﻿using System;
using Bailun.Core.Extension.Entity;
using Bailun.Core.Extension.Json;


/****************************************************************
*   作者：tianzh
*   创建时间：2018/4/4 15:13:22
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/
namespace Bailun.Core.Extension.Utils
{
    /// <summary>
    /// abpapi请求辅助类
    /// </summary>
    public class AbpApiHelper
    {
        /// <summary>
        /// get请求
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static AbpApiOperationOuput HttpGet(string url)
        {
            try
            {
                
                   var result = HttpClientManager.HttpGet(url);

                var jsonResult = JsonHelper.FromJson<AbpApiOperationOuput>(result);
                 return jsonResult;
                
            }
            catch (Exception ex)
            {
                return new AbpApiOperationOuput() {Success = false,Error = ex.Message+","};
            }
        }

     
        /// <summary>
        /// get请求
        /// </summary>
        /// <param name="url"></param>
        /// <param name="postData"></param>
        /// <returns></returns>
        public static AbpApiOperationOuput HttpPost(string url,string postData)
        {
            try
            {
               
                var result = HttpClientManager.HttpPost(url, postData);

                var jsonResult = JsonHelper.FromJson<AbpApiOperationOuput>(result);
                return jsonResult;

            }
            catch (Exception ex)
            {
                return new AbpApiOperationOuput() { Success = false, Error = ex.Message + "," };
            }
        }

        /// <summary>
        /// post请求
        /// </summary>
        /// <param name="url"></param>
        /// <param name="postData"></param>
        /// <returns></returns>
        public static AbpApiOperationOuput PostHttpAsync<T1>(string url, T1 postData)
        {
            try
            {
                var result = HttpClientManager.PostHttpAsync(url, postData);

                var jsonResult = JsonHelper.FromJson<AbpApiOperationOuput>(result);
                return jsonResult;

            }
            catch (Exception ex)
            {
                return new AbpApiOperationOuput() { Success = false, Error = ex.Message + "," };
            }
        }

    }
}
