﻿using System.Linq;
using System.Security.Claims;
using System.Threading;
using Abp.Runtime.Session;
using Bailun.Core.Extension.Utils;

namespace Bailun.Core.Extension.Runtime
{
    /// <summary>
    /// 版 本 1.0
    /// Copyright (c) 2016-2021 广州tianzh
    /// 创建人：tianzh
    /// 日 期：2016/12/28 13:51:19
    /// 描 述：
    /// </summary>
    public static class SessionExtension
    {
        public static string GetUserName(this IAbpSession session)
        {
            try
            {
                ////在ABP源码中也是通过DefaultPrincipalAccessor.Instance来获取PrincipalAccessor  即此处的DefaultPrincipalAccessor.Instance等价于上文中的PrincipalAccessor
                //var userIdClaim = DefaultPrincipalAccessor.Instance.Principal?.Claims.FirstOrDefault(c => c.Type == "UserName");
                //if (userIdClaim == null)
                //    throw new AbpException("Session.UserName is null! Possible problems: No user logged in or current logged in user in a host user (TenantId is always null for host users).");

                //return userIdClaim.Value;
                var claimsPrincipal = Thread.CurrentPrincipal as ClaimsPrincipal;

                var claim = claimsPrincipal?.Claims.FirstOrDefault(c => c.Type == ClaimTypes.Name);
                if (claim == null || string.IsNullOrEmpty(claim.Value))
                {
                    return "system";
                }

                return claim.Value;
            }
            catch
            {
                return "system";
            }
        }
        /// <summary>
        /// 当前登录用户Id
        /// </summary>
        /// <param name="session"></param>
        /// <returns></returns>
        public static int GetUid(this IAbpSession session)
        {
            try
            {
                var claimsPrincipal = Thread.CurrentPrincipal as ClaimsPrincipal;

                var claim = claimsPrincipal?.Claims.FirstOrDefault(c => c.Type == ClaimTypes.NameIdentifier);
                if (claim == null || string.IsNullOrEmpty(claim.Value))
                {
                    return 0;
                }

                return claim.Value.ToInt32();
            }
            catch
            {
                return 0;
            }
        }
    }
}
