﻿using System.Collections;
using Newtonsoft.Json;

namespace Bailun.Core.Extension.Page
{
    /// <summary>
    /// 分页返回值
    /// </summary>
   public class PageResult<TData> where TData : IList
    {
        /// <summary>
        /// 每页行数
        /// </summary>
        [JsonProperty("rows")]
        public int Rows
        {
            get
            {
                if (Data != null)
                {
                    return Data.Count;
                }
                else
                {
                    return 0;
                }
            }
        }
        /// <summary>
        /// 返回结果
        /// </summary>
        [JsonProperty("data")]
        public TData Data { set; get; }
        /// <summary>
        /// 当前页
        /// </summary>
        [JsonProperty("pageIndex")]
        public int PageIndex { get; set; }
        /// <summary>
        /// 总条数
        /// </summary>
        [JsonProperty("total")]
        public long Total { get; set; }
        /// <summary>
        /// 总页数
        /// </summary>
        [JsonProperty("totalPage")]
        public long TotalPage
        {
            get
            {
                if (Total > 0)
                {
                    return Total % this.Rows == 0 ? Total / this.Rows : Total / this.Rows + 1;
                }
                else
                {
                    return 0;
                }
            }
        }

        /// <summary>
        /// 构造返回值
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="records"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public PageResult<TData> ToPageResult(int pageIndex, long records, TData data)
        {
            return new PageResult<TData>()
            {
                Data = data,
                PageIndex = pageIndex,
                Total = records
            };
        } 
    }
}
