﻿using System;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using Abp.Extensions;

namespace Bailun.Core.Extension.Linq
{
        /// <summary>
    /// 用于lambda表达式排序获取分页query语句
    /// </summary>
   public class LambdaHelper
    {
        /// <summary>
        /// 根据字符串order转化为lambda排序
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="queryableAction"></param>
        /// <param name="orderField"></param>
        /// <param name="orderType"></param>
        /// <returns></returns>
            public static IQueryable<T> GetOrderByAndSort<T>(IQueryable<T> queryableAction, string orderField,
                string orderType)
            {
                MethodCallExpression resultExp = null;
                var isAsc = orderType.ToLower() != "desc";
                var parameter = Expression.Parameter(typeof (T), "t");
            if (!orderField.IsNullOrEmpty())
            {

                orderField = orderField.ToUpper().Substring(0, 1) + orderField.Substring(1, orderField.Length - 1);
            }
                var property = typeof (T).GetProperty(orderField);
                var propertyAccess = Expression.MakeMemberAccess(parameter, property);
                var orderByExp = Expression.Lambda(propertyAccess, parameter);
                resultExp = Expression.Call(typeof (Queryable), isAsc ? "OrderBy" : "OrderByDescending",
                    new[] {typeof (T), property.PropertyType}, queryableAction.Expression, Expression.Quote(orderByExp));
                return queryableAction.Provider.CreateQuery<T>(resultExp);
            }

        /// <summary>
        /// 获取Lambda表达式搜索
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="queryableAction"></param>
        /// <param name="field">注意大小写</param>
        /// <param name="searchValue">注意大小写</param>
        /// <param name="callMethod">注意大小写</param>
        /// <returns></returns>
        public static Expression<Func<T, bool>> GetLambda<T>(IQueryable<T> queryableAction, string field, string searchValue,
                string callMethod)
            {
                if (field.IsNullOrEmpty() || searchValue.IsNullOrEmpty() || callMethod.IsNullOrEmpty())
                {
                    return p=>true;
                }
             var parameter = Expression.Parameter(typeof (T), "t");

            MemberExpression namePropExpr = Expression.Property(parameter, field);  // 创建表示Name属性的表达式
            MethodInfo containsMethod = typeof(string).GetMethod(callMethod);  // 获取表示System.String.Contains方法的System.Reflection.MethodInfo
            ConstantExpression nameValueExpr = Expression.Constant(searchValue, typeof(string));  // 创建表示value变量值的表达式
            MethodCallExpression callExpression = Expression.Call(namePropExpr, containsMethod, nameValueExpr);  // 创建表示name参数的表达式

                // 生成Lambda表达式
            var lambda = Expression.Lambda<Func<T, bool>>(callExpression, parameter);
           return lambda;
            }


    }
    /// <summary>
    /// 查询类型
    /// </summary>
    public enum QueryType
    {
        /// <summary>
        /// 包含
        /// </summary>
        Contains=1,
        /// <summary>
        /// 等于
        /// </summary>
        Equals=2,

    }
}
