﻿using Newtonsoft.Json;

namespace Bailun.Core.Extension.Entity.Tree.Model
{
    /// <summary>
    /// TreeEntity model
    /// </summary>
    public class TreeEntity
    {
        [JsonProperty("id")]
        public string Id { get; set; }
        //[JsonProperty("parent")]
        public string ParentId { get; set; }
        /// <summary>
        /// 字典值
        /// </summary>
        [JsonProperty("text")]
        public string Text { get; set; }

        /// <summary>
        /// 程序编码（如PayType：WeChat（1），Alipay（2），WeChat就是Code，也就是程序调用时命名
        /// </summary>
        [JsonProperty("value")]
        public string Value { get; set; }
        /// <summary>
        /// 选中状态
        /// </summary>
        [JsonProperty("checkstate")]
        public int? CheckState { get; set; }
        /// <summary>
        /// 是否现实checkbox
        /// </summary>
        [JsonProperty("showcheck")]
        public bool ShowCheck { get; set; }
        /// <summary>
        /// 是否显示全部
        /// </summary>
        [JsonProperty("complete")]
        public bool Complete { get; set; }

        /// <summary>
        /// 是否展开
        /// </summary>
        [JsonProperty("isexpand")]
        public bool IsExpand { get; set; }
        /// <summary>
        /// 是否显示全部
        /// </summary>
        [JsonProperty("hasChildren")]
        public bool HasChildren { get; set; }

        /// <summary>
        /// 图片
        /// </summary>
        [JsonProperty("img")]
        public string Img { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        [JsonProperty("title")]
        public string Title { get; set; }
        /// <summary>
        /// 图片
        /// </summary>
        [JsonProperty("Level")]
        public int? Level { get; set; }

        /// <summary>
        /// 自定义属性
        /// </summary>
        [JsonProperty("Attribute")]
        public string Attribute { get; set; }
        /// <summary>
        /// 自定义属性的值
        /// </summary>
        [JsonProperty("AttributeValue")]
        public string AttributeValue { get; set; }
    }
 
}
