﻿using System;
using Abp.Domain.Entities;
using Abp.Domain.Entities.Auditing;


/****************************************************************
*   作者：tianzh
*   创建时间：2018/4/4 11:31:32
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/
namespace Bailun.Core.Extension.Domain.Entity
{
    /// <summary>
    /// 请求的字段
    /// </summary>
    public class ProFullAUditedEntityRequest
    {
        public DateTime CreationTime { get; set; }
        public string CreatorUserId { get; set; }
        public string CreateUserName { get; set; }
        public string CreatorDepartmentId { get; set; }
        public string CreatorOrganizeId { get; set; }
        public DateTime? LastModificationTime { get; set; }
        public string LastModifierUserName { get; set; }
        public string LastModifierUserId { get; set; }
    }
    /// <summary>
    /// 百伦产品库公共实体
    /// </summary>
    /// <typeparam name="TPrimaryKey"></typeparam>
    public interface IBltProFullAuditedEntity<TPrimaryKey> : IEntity<TPrimaryKey>, ISoftDelete, IHasCreationTime, IHasDeletionTime, IHasModificationTime
    {

    }
    /// <summary>
    /// 百伦产品库公共实体
    /// </summary>
    /// <typeparam name="TPrimaryKey"></typeparam>
    [Serializable]
    public abstract class BltProFullAuditedEntity<TPrimaryKey> : Entity<TPrimaryKey>, IBltProFullAuditedEntity<TPrimaryKey>
    {
        public DateTime CreationTime { get; set; }
        public string CreatorUserId { get; set; }
        public string CreateUserName { get; set; }
        public string CreatorDepartmentId { get; set; }
        public string CreatorOrganizeId { get; set; }
        public DateTime? LastModificationTime { get; set; }
        public string LastModifierUserName { get; set; }
        public string LastModifierUserId { get; set; }
        public bool IsDeleted { get; set; }
        public string DeleterUserId { get; set; }
        public string DeleteUserName { get; set; }
        public DateTime? DeletionTime { get; set; }

    }

    /// <summary>
    /// 百伦产品库公共实体,不带公司id和部门id
    /// </summary>
    /// <typeparam name="TPrimaryKey"></typeparam>
    [Serializable]
    public abstract class BltProFullAuditedLessEntity<TPrimaryKey> : Entity<TPrimaryKey>, IBltProFullAuditedEntity<TPrimaryKey>
    {
        public DateTime CreationTime { get; set; }
        public string CreatorUserId { get; set; }
        public string CreateUserName { get; set; }
        public DateTime? LastModificationTime { get; set; }
        public string LastModifierUserName { get; set; }
        public string LastModifierUserId { get; set; }
        public bool IsDeleted { get; set; }
        public string DeleterUserId { get; set; }
        public string DeleteUserName { get; set; }
        public DateTime? DeletionTime { get; set; }

    }
}
