﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Abp.Domain.Entities.Auditing;

namespace Bailun.Core.Extension.Domain.Entity
{
    /// <summary>
    /// 模型基类
    /// </summary>
    /// <typeparam name="TEntity"></typeparam>
    [Serializable]
    public class BaseEntity<TEntity> : FullAuditedEntity<TEntity>
    {
        /// <summary>
        /// 最大长度
        /// </summary>
        public const int MaxLength = 20;

        /// <summary>
        /// 创建人
        /// </summary>
        [Column("create_user"), StringLength(MaxLength)]
        public virtual string CreateUserName { get; set; } = "";

        /// <summary>
        /// 创建id
        /// </summary>
        [Column("create_user_id")]
        public override long? CreatorUserId { get; set; } = 0;

        /// <summary>
        /// 创建时间
        /// </summary>
        [Column("create_time")]
        public override DateTime CreationTime { get; set; } = DateTime.Now;

        /// <summary>
        /// 修改人
        /// </summary>
        [Column("modify_user"), StringLength(MaxLength)]
        public virtual string LastModifierUserName { get; set; } = "";

        /// <summary>
        /// 修改人id
        /// </summary>
        [Column("modify_user_id")]
        public override long? LastModifierUserId { get; set; } = 0;

        /// <summary>
        /// 修改时间
        /// </summary>
        [Column("modify_time")]
        public override DateTime? LastModificationTime { get; set; } = DateTime.Now;

        /// <summary>
        /// 删除人
        /// </summary>
        [Column("deleted_user"), StringLength(MaxLength)]
        public virtual string DeleteUserName { get; set; } = "";

        /// <summary>
        /// 删除人id
        /// </summary>
        [Column("deleted_user_id")]
        public override long? DeleterUserId { get; set; } = 0;

        /// <summary>
        /// 删除时间
        /// </summary>
        [Column("deleted_time")]
        public override DateTime? DeletionTime { get; set; } = DateTime.Now;

        /// <summary>
        /// 是否删除
        /// </summary>
        [Column("is_deleted", TypeName = "bit")]
        public override bool IsDeleted { get; set; } = false;
    }
}
