﻿using Bailun.Core.Core;
using Bailun.Core.Core.Configuration;
using Bailun.Core.Core.Web;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Design;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.EntityFrameworkCore.EntityFrameworkCore
{
    /* This class is needed to run "dotnet ef ..." commands from command line on development. Not used anywhere else */
    public class BaseDbContextFactory : IDesignTimeDbContextFactory<BaseDbContext>
    {
        public BaseDbContext CreateDbContext(string[] args)
        {
            var builder = new DbContextOptionsBuilder<BaseDbContext>();
            var configuration = AppConfigurations.Get(WebContentDirectoryFinder.CalculateContentRootFolder());

            BaseDbContextConfigurer.Configure(builder, configuration.GetConnectionString(ProductConsts.ConnectionStringName));

            return new BaseDbContext(builder.Options);
        }
    }
}
