﻿using System;
using Microsoft.Extensions.Logging;

namespace Bailun.Core.EntityFrameworkCore.EntityFrameworkCore
{
    public class EFLogger : ILogger
    {
        private readonly string categoryName;

        public EFLogger(string categoryName) => this.categoryName = categoryName;

        public bool IsEnabled(LogLevel logLevel) => true;

        public void Log<TState>(LogLevel logLevel, EventId eventId, TState state, Exception exception, Func<TState, Exception, string> formatter)
        {
            //ef core执行数据库查询时的categoryName为Microsoft.EntityFrameworkCore.Database.Command,日志级别为Information
            if (categoryName == "Microsoft.EntityFrameworkCore.Database.Command"
                    && logLevel == LogLevel.Information)
            {
                var logContent = formatter(state, exception);
                //TODO: 拿到日志内容想怎么玩就怎么玩吧
                Console.WriteLine("<------------------ sql start ------------------>");
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.Write("sql: ");
                Console.ResetColor();
                Console.Write(logContent);
                Console.ResetColor();
                Console.WriteLine();
                Console.WriteLine("<------------------ sql end ------------------>");
            }
        }

        public IDisposable BeginScope<TState>(TState state) => null;
    }
}
