﻿using Abp.AutoMapper;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Core;

namespace Bailun.Core.Application
{
    [DependsOn(
        typeof(BaseCoreModule),
        typeof(AbpAutoMapperModule))]
    public class ProductApplicationModule : AbpModule
    {
        public override void PreInitialize()
        {
            //  Configuration.Authorization.Providers.Add<PublishListingAuthorizationProvider>();

            Configuration.Modules.AbpAutoMapper().Configurators.Add(mapper =>
            {


            });
        }

        public override void Initialize()
        {
            var thisAssembly = typeof(ProductApplicationModule).GetAssembly();

            IocManager.RegisterAssemblyByConvention(thisAssembly);
   

            Configuration.Modules.AbpAutoMapper().Configurators.Add(
                // Scan the assembly for classes which inherit from AutoMapper.Profile
                cfg => cfg.AddProfiles(thisAssembly)
            );
        }
    }
}
