﻿using System.Collections.Generic;
using System.Threading.Tasks;
using Abp.Application.Services;
using Abp.Domain.Entities;
using Bailun.Core.Extension.Page;

namespace Bailun.Core.Application
{
    public interface IBaseApplicationService<TEntity> : IApplicationService where TEntity : class, IEntity<int>
    {
        #region CURD
        /// <summary>
        /// 查询
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task<TEntity> GetAsync(int id);

        /// <summary>
        /// 新增
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        Task<TEntity> InsertAsync(TEntity value);

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="id"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        Task UpdateAsync(int id, TEntity value);

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        Task DeleteAsync(int id);

        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        Task<IList<TEntity>> ListAsync();

        /// <summary>
        /// 批量新增
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        Task BatchInsertAsync(IList<TEntity> values);

        /// <summary>
        /// 批量删除
        /// </summary>
        /// <param name="ids"></param>
        /// <returns></returns>
        Task BatchDeleteAsync(int[] ids);

        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="page"></param>
        /// <returns></returns>
        Task<PageResult<List<TEntity>>> PageAsync(PageRequest page);
        #endregion
    }
}
