﻿using System;
using System.Collections.Generic;
using System.Linq;
using Abp.AspNetCore;
using Bailun.Core.Service.Core.Configuration;
using Bailun.ServiceFabric.ApiGateway;
using Exceptionless;
using Exceptionless.Models;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;

namespace Bailun.Core.ApiGateway.Startup
{
    public class Startup
    {
        private readonly IConfigurationRoot _appConfiguration;
        public Startup(IHostingEnvironment env)
        {
            _appConfiguration = env.GetConfiguration();
        }

        // This method gets called by the runtime. Use this method to add services to the container.
        public IServiceProvider ConfigureServices(IServiceCollection services)
        {
            services.AddSingleton<IConfigurationRoot>();
            AuthConfigurer.Configure(services, _appConfiguration);
            return services.AddAbp<ApiGatewayModule>();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IHostingEnvironment env, ILoggerFactory loggerFactory)
        {
            loggerFactory.AddExceptionless();
            app.UseAbp();
            app.UseResponseCompression();
            app.UseStaticFiles();
            app.UseApiGateway(_appConfiguration, loggerFactory);
            ExceptionlessClient.Default.SubmittingEvent += Default_SubmittingEvent;
        }


        /// <summary>
        /// 默认提交异常处理事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void Default_SubmittingEvent(object sender, EventSubmittingEventArgs e)
        {
            var argEvent = e.Event;
            if (argEvent.Type == Event.KnownTypes.Log && argEvent.Source == "Ocelot.Configuration.Repository.FileConfigurationPoller")
            {
                e.Cancel = true;
                return;
            }
            // 只处理未处理的异常
            if (!e.IsUnhandledError)
                return;


            //忽略没有错误体的错误
            var error = argEvent.GetError();
            if (error == null)
                return;

            // 忽略404错误
            if (e.Event.IsNotFound())
            {
                e.Cancel = true;
                return;
            }

            //忽略401(Unauthorized)和请求验证的错误.
            if (error.Code == "401")
            {
                e.Cancel = true;
                return;
            }

            //忽略任何未被代码抛出的异常
            var handledNamespaces = new List<string> { "Exceptionless" };
            var handledNamespaceList = error.StackTrace.Select(s => s.DeclaringNamespace).Distinct();
            if (!handledNamespaceList.Any(ns => handledNamespaces.Any(ns.Contains)))
            {
                e.Cancel = true;
                return;
            }

            e.Event.Tags.Add("未捕获异常");//添加系统异常标签
            e.Event.MarkAsCritical();//标记为关键异常

        }
    }
}
