﻿using System.Linq;
using Bailun.Core.Service.Core.Identity;
using Bailun.ServiceFabric.ApiGateway;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.ResponseCompression;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;

namespace Bailun.Core.ApiGateway.Startup
{
    public static class AuthConfigurer
    {
        private const string _defaultCorsPolicyName = "127.0.0.1";
        private const string _authenticationProviderKey = "ApiGatewayKey";

        public static void Configure(IServiceCollection services, IConfiguration configuration)
        {
            services.AddMvc().SetCompatibilityVersion(CompatibilityVersion.Version_2_1);

            //添加Exceptionless服务
            //services.AddServiceExceptionless();
            //添加身份认证
            var identityServerOptions = new IdentityServerOptions();
            configuration.Bind("IdentityServerOptions", identityServerOptions);
            void identityServerAuthenticationOptions(IdentityServerAuthenticationOptions o)
            {
                o.RequireHttpsMetadata = false; //是否启用https
                o.Authority = $"http://{identityServerOptions.ServerIP}:{identityServerOptions.ServerPort}";//配置授权认证的地址
                o.ApiName = identityServerOptions.ResourceName; //资源名称，跟认证服务中注册的资源列表名称中的apiResource一致
                o.SupportedTokens = SupportedTokens.Both;
                o.ApiSecret = "secret";
            };
            services.AddAuthentication(identityServerOptions.IdentityScheme)
                .AddIdentityServerAuthentication(_authenticationProviderKey, identityServerAuthenticationOptions);

            //添加网关服务
            services.AddApiGateway(configuration, identityServerAuthenticationOptions);

            //Brotli和Gzip压缩
            services.AddResponseCompression(options =>
            {
                options.Providers.Add<BrotliCompressionProvider>();
                options.Providers.Add<GzipCompressionProvider>();
                options.MimeTypes = ResponseCompressionDefaults.MimeTypes.Concat(new[] { "image/svg+xml" });
            });

        }
    }
}
