﻿using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Service.Core;
using Bailun.Core.Service.Core.Configuration;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.WebApiDemo.Startup
{
    [DependsOn(typeof(ProductWebCoreModule))]
    public class ProductWebHostModule:AbpModule
    {
        private readonly IHostingEnvironment _env;
        private readonly IConfigurationRoot _appConfiguration;

        public ProductWebHostModule(IHostingEnvironment env)
        {
            _env = env;
            _appConfiguration = env.GetConfiguration();
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ProductWebHostModule).GetAssembly());
        }
    }
}
