﻿using Abp.Dependency;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Abp.Threading.BackgroundWorkers;
using Bailun.Core.Core;
using Bailun.Core.TaskJob.IBackgroudWorker;

namespace Bailun.Core.TaskJob
{
    [DependsOn(
        typeof(BaseCoreModule))]
    public class ProductTaskJobModule : AbpModule
    {

        public override void PreInitialize()
        {
            base.PreInitialize();
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ProductTaskJobModule).GetAssembly());
        }

        public override void PostInitialize()
        {
            IocManager.RegisterIfNot<IBackgroudWorkerProxy, PeriodicWorkerPxoxy>();
            var workManager = IocManager.Resolve<IBackgroundWorkerManager>();
            //workManager.Add(IocManager.Resolve<SyncCategoryBailunWorker>());
            //workManager.Add(IocManager.Resolve<SyncCategoryWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductExploitWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductGroupWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductInfoWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductLogWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductSkuWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductSkuStateWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductSupplierRelateWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductSupplierWorker>());
            //workManager.Add(IocManager.Resolve<SyncProductWareWorker>());
            //workManager.Add(IocManager.Resolve<SyncSkuMappingWorker>());
            //workManager.Add(IocManager.Resolve<SyncPublishWorker>());
            base.PostInitialize();
        }
    }
}
