﻿using System;
using Abp.Threading.Timers;
using Bailun.Core.TaskJob.IBackgroudWorker;
using Castle.Core.Logging;

namespace Bailun.Core.TaskJob
{
    public class PeriodicWorkerPxoxy : IBackgroudWorkerProxy
    {
        private readonly ILogger _logger;
        public PeriodicWorkerPxoxy(ILogger logger)
        {
            _logger = logger;
        }
        private Action ExetuteMethod { get; set; }
        protected readonly AbpTimer Timer;
        public PeriodicWorkerPxoxy(AbpTimer timer)
        {
            Timer = timer;
            Timer.Elapsed += Timer_Elapsed;
        }

        private void Timer_Elapsed(object sender, EventArgs e)
        {
            try
            {
                DoWork();
            }
            catch (Exception ex)
            {
                _logger.Error(ex.Message);
            }
        }

        public void Excete<T>(Action method, WorkerConfig config) where T : IBackgroundWorkerDo
        {
            ExetuteMethod = method;
            Timer.Period = config.IntervalSecond * 1000;//将传入的秒数转化为毫秒
            Timer.Start();
        }

        protected void DoWork()
        {
            ExetuteMethod();
        }
    }
}
