﻿using System;
using Bailun.Core.Service.Core.Configuration;
using Bailun.Core.TaskJob.IBackgroudWorker;
using Hangfire;
using Hangfire.Common;
using Hangfire.Redis;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.TaskJob.Hangfire
{
    public class HangfireWorkerPxoxy : IBackgroudWorkerProxy
    {
        private readonly IConfigurationRoot _appConfiguration;
        public HangfireWorkerPxoxy(IHostingEnvironment env)
        {
            _appConfiguration = env.GetConfiguration();
        }
        private WorkerConfig Config { get; set; }
        public void Excete<T>(Action method, WorkerConfig config) where T : IBackgroundWorkerDo
        {
            //JobStorage.Current = new MySqlStorage(_appConfiguration.GetConnectionString("Task"), new MySqlStorageOptions
            //{
            //    QueuePollInterval = TimeSpan.FromSeconds(15),
            //    JobExpirationCheckInterval = TimeSpan.FromHours(1),
            //    CountersAggregateInterval = TimeSpan.FromMinutes(5),
            //    PrepareSchemaIfNecessary = true,
            //    DashboardJobListLimit = 50000,
            //    TransactionTimeout = TimeSpan.FromMinutes(1),
            //});
            var options = new RedisStorageOptions
            {
                Db = _appConfiguration.GetValue<int>("redis:Defaultdatabase"),
                SucceededListSize = 50000,
                DeletedListSize = 50000,
                ExpiryCheckInterval = TimeSpan.FromHours(1),
                InvisibilityTimeout = TimeSpan.FromHours(3)
            };
            var redisString = _appConfiguration.GetValue<string>("redis:HostName") + ":" + _appConfiguration.GetValue<string>("redis:Port");
            JobStorage.Current = new RedisStorage(redisString);
            var manager = new RecurringJobManager(JobStorage.Current);
            Config = config;
            string workerId = config.WorkerId;
            string cron = Cron.MinuteInterval(config.IntervalSecond / 60);
            manager.RemoveIfExists(workerId);
            manager.AddOrUpdate(workerId, Job.FromExpression<T>((t) => t.DoWorkAsync(null)), cron, TimeZoneInfo.Local, string.IsNullOrEmpty(config.QueuesName) ? "default" : config.QueuesName);
            //RecurringJob.Trigger(workerId);
        }
    }
}
