﻿using Abp.Dependency;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Core;
using Bailun.Core.TaskJob.IBackgroudWorker;

namespace Bailun.Core.TaskJob.Hangfire
{
    [DependsOn(
           typeof(BaseCoreModule))]
    public class HangFireWorkerModule : AbpModule
    {
        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(HangFireWorkerModule).GetAssembly());
        }
        public override void PreInitialize()
        {
            IocManager.RegisterIfNot<IBackgroudWorkerProxy, HangfireWorkerPxoxy>();
            base.PreInitialize();
        }
    }
}
