﻿using Abp.AspNetCore;
using Abp.AspNetCore.Configuration;
using Abp.AspNetCore.SignalR;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.Core.Application;
using Bailun.Core.Core;
using Bailun.Core.EntityFrameworkCore.EntityFrameworkCore;
using Bailun.Core.Service.Core.Configuration;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;

namespace Bailun.Core.Service.Core
{
    [DependsOn(
         typeof(ProductApplicationModule),
         typeof(BaseEntityFrameworkModule),
         typeof(AbpAspNetCoreModule)
        ,typeof(AbpAspNetCoreSignalRModule)
     )]
    public class ProductWebCoreModule : AbpModule
    {
        private readonly IHostingEnvironment _env;
        private readonly IConfigurationRoot _appConfiguration;

        public ProductWebCoreModule(IHostingEnvironment env)
        {
            _env = env;
            _appConfiguration = env.GetConfiguration();
        }

        public override void PreInitialize()
        {
            Configuration.DefaultNameOrConnectionString = _appConfiguration.GetConnectionString(
                 ProductConsts.ConnectionStringName
             );

            Configuration.Modules.AbpAspNetCore().DefaultWrapResultAttribute.WrapOnSuccess = false;
            Configuration.Modules.AbpAspNetCore().DefaultWrapResultAttribute.WrapOnError = false;
        }

        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ProductWebCoreModule).GetAssembly());
        }
    }
}
