using Abp.AspNetCore.Mvc.Controllers;
using Abp.Domain.Entities;
using Abp.IdentityFramework;
using Bailun.Core.Application;
using Bailun.Core.Core;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;

namespace Bailun.Core.Service.Core.Controllers
{
    [Route("[controller]")]
    [Produces("application/json")]
    public abstract class ApiControllerBase<TEntity> : AbpController where TEntity : class, IEntity<int>
    {
        private readonly IBaseApplicationService<TEntity> _baseApplicationService;
        protected ApiControllerBase(IBaseApplicationService<TEntity> baseApplicationService)
        {
            LocalizationSourceName = ProductConsts.LocalizationSourceName;
            _baseApplicationService = baseApplicationService;
        }

        protected void CheckErrors(IdentityResult identityResult)
        {
            identityResult.CheckErrors(LocalizationManager);
        }

        //#region CURD
        ///// <summary>
        ///// ѯ
        ///// </summary>
        ///// <param name="id"></param>
        ///// <returns></returns>
        //[HttpGet]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task<TEntity> Get(int id)
        //{
        //    return await _baseApplicationService.GetAsync(id);
        //}

        ///// <summary>
        ///// 
        ///// </summary>
        ///// <param name="value"></param>
        ///// <returns></returns>
        //[HttpPost]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task Post([FromBody] TEntity value)
        //{
        //    await _baseApplicationService.InsertAsync(value);
        //}

        ///// <summary>
        ///// ޸
        ///// </summary>
        ///// <param name="id"></param>
        ///// <param name="value"></param>
        ///// <returns></returns>
        //[HttpPut]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task Put(int id, [FromBody] TEntity value)
        //{
        //    await _baseApplicationService.UpdateAsync(id, value);
        //}

        ///// <summary>
        ///// ɾ
        ///// </summary>
        ///// <param name="id"></param>
        ///// <returns></returns>
        //[HttpDelete]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task Delete(int id)
        //{
        //    await _baseApplicationService.DeleteAsync(id);
        //}

        ///// <summary>
        ///// б
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet("List")]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task<IList<TEntity>> List()
        //{
        //    return await _baseApplicationService.ListAsync();
        //}

        ///// <summary>
        ///// 
        ///// </summary>
        ///// <returns></returns>
        //[HttpPost("BatchInsert")]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task BatchInsertAsync(IList<TEntity> values)
        //{
        //    await _baseApplicationService.BatchInsertAsync(values);
        //}

        ///// <summary>
        ///// ɾ
        ///// </summary>
        ///// <returns></returns>
        //[HttpDelete("BatchDelete")]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task BatchDeleteAsync(int[] ids)
        //{
        //    await _baseApplicationService.BatchDeleteAsync(ids);
        //}

        ///// <summary>
        ///// ҳѯ
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet("Page")]
        //[ApiExplorerSettings(IgnoreApi = true)]
        //public async Task<PageResult<List<TEntity>>> PageAsync(PageRequest page)
        //{
        //    return await _baseApplicationService.PageAsync(page);
        //}
        //#endregion
    }
}
