﻿using Bailun.Core.Core.Configuration;
using Bailun.Core.EntityFrameworkCore.EntityFrameworkCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;

namespace Bailun.Core.Service.Core.Configuration
{
    public static class HostingEnvironmentExtensions
    {
        public static IConfigurationRoot GetConfiguration(this IHostingEnvironment env)
        {

          
            return AppConfigurations.Get(env.ContentRootPath, env.EnvironmentName, env.IsDevelopment());
        }

        public static IServiceCollection AddWebDbContext(this IServiceCollection services, string connectionString)
        {
            var loggerFactory = new LoggerFactory();
            loggerFactory.AddProvider(new EFLoggerProvider());
            services.AddDbContext<BaseDbContext>(options =>
            {
                options
                .UseMySql(connectionString)
                .UseLoggerFactory(loggerFactory);
            });
            return services;
        }
    }
}
