﻿using System;
using System.Security.Cryptography;
using System.Text;

namespace Bailun.Core.Extension.Utils
{
    /// <summary>
    /// MD5Provider 的摘要说明
    /// </summary>
    public class MD5Helper
    {

        #region 根据输入的字符串参数，返回MD5加密后的字符串
        /// <summary>
        /// 根据输入的字符串参数，返回MD5加密后的字符串
        /// </summary>
        /// <param name="input">input 输入参数</param>
        /// <returns></returns>
        public static string GetMd5Hash(string input)
        {
            if (string.IsNullOrEmpty(input))
            {
                return string.Empty;
            }
            MD5 md5 = System.Security.Cryptography.MD5.Create();
            byte[] data = md5.ComputeHash(Encoding.Default.GetBytes(input));
            // Create a new Stringbuilder to collect the bytes
            // and create a string.
            StringBuilder sBuilder = new StringBuilder();
            // Loop through each byte of the hashed data 
            // and format each one as a hexadecimal string.
            for (int i = 0; i < data.Length; i++)
            {
                sBuilder.Append(data[i].ToString("x2"));
            }
            // Return the hexadecimal string.
            return Revert(sBuilder.ToString());

        } 
        #endregion

        #region 比较一个输入的字符传和一个已二次加密的MD5字符串是否相等
        /// <summary>
        /// 比较一个输入的字符传和一个已二次加密的MD5字符串是否相等
        /// </summary>
        /// <param name="input">input 输入字符串</param>
        /// <param name="hash">hash  已有MD5字符串</param>
        /// <returns></returns>
        public static bool VerifyMd5Hash(string input, string hash)
        {
            // Hash the input.
            string hashOfInput = GetMd5Hash(input);
            // Create a StringComparer an comare the hashes.
            StringComparer comparer = StringComparer.OrdinalIgnoreCase;
            if (0 == comparer.Compare(hashOfInput, hash))
            {
                return true;
            }
            else
            {
                return false;
            }
        } 
        #endregion

        #region MD5二次加密
        /// <summary>
        /// MD5二次加密
        /// </summary>
        /// <param name="input">input 输入字符串</param>
        /// <returns></returns>
        public static string Revert(string input)
        {
            string md5Hash = input;
            StringBuilder sb = new StringBuilder();
            for (int i = md5Hash.Length - 1; i >= 0; i--)
            {
                char ch = md5Hash[i];
                sb.Append(ch);
            }
            return sb.ToString();
        } 
        #endregion


        #region md5加密，返回加密后32位小写 hewencong
        /// <summary>
        /// md5加密，返回加密后32位小写
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string GetMd5HashLower(string input)
        {
            if (string.IsNullOrEmpty(input))
            {
                return string.Empty;
            }
            MD5 md5 = System.Security.Cryptography.MD5.Create();
            byte[] data = md5.ComputeHash(Encoding.Default.GetBytes(input));
            // Create a new Stringbuilder to collect the bytes
            // and create a string.
            StringBuilder sBuilder = new StringBuilder();
            // Loop through each byte of the hashed data 
            // and format each one as a hexadecimal string.
            for (int i = 0; i < data.Length; i++)
            {
                sBuilder.Append(data[i].ToString("x2"));
            }
            // Return the hexadecimal string.
            return sBuilder.ToString();
        } 
        #endregion
    }
}