﻿/****************************************************************
*   作者：tianzh
*   创建时间：2017/8/17 11:49:09
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/

using System;
using System.Linq;
using System.Text.RegularExpressions;

namespace Bailun.Core.Extension.Utils
{
    /// <summary>
    /// 图片工具辅助类
    /// </summary>
   public class ImageToolHelper
    {
        /// <summary>
        /// 获取在线url的图片扩展名信息
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string GetImgFileExtension(string url)
        {
            if (!url.Contains(".")) //如果不包含.则默认jpg
            {
                return "jpg";
            }
            if (url.Contains("?"))
            {
                var index = url.IndexOf("?", StringComparison.Ordinal);
                url = url.Substring(0, index);
            }
           var arr= url.Split('.');
          return   arr.LastOrDefault();
        }

        /// <summary>
        /// 获取默认图片路径
        /// </summary>
        /// <param name="img"></param>
        /// <returns></returns>
        public static string GetDefaultImage(string img)
        {
            if (img.IsNullOrEmpty())
            {
                return "/Content/ProMgr/Base/images/notfound.png";
            }
            return img;
        }
        #region 取得HTML中所有图片的 URL。 
        /// <summary> 
        /// 取得HTML中所有图片的 URL。 
        /// </summary> 
        /// <param name="sHtmlText">HTML代码</param> 
        /// <returns>图片的URL列表</returns> 
        public static string[] GetHtmlImageUrlList(string sHtmlText)
        {
            // 定义正则表达式用来匹配 img 标签 
            Regex regImg = new Regex(@"<img\b[^<>]*?\bsrc[\s\t\r\n]*=[\s\t\r\n]*[""']?[\s\t\r\n]*(?<imgUrl>[^\s\t\r\n""'<>]*)[^<>]*?/?[\s\t\r\n]*>", RegexOptions.IgnoreCase);

            // 搜索匹配的字符串 
            MatchCollection matches = regImg.Matches(sHtmlText);
            int i = 0;
            string[] sUrlList = new string[matches.Count];

            // 取得匹配项列表 
            foreach (Match match in matches)
                sUrlList[i++] = match.Groups["imgUrl"].Value;
            return sUrlList;
        }
        #endregion
    }
}
