﻿using System;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using System.Web;
using Newtonsoft.Json;

namespace Bailun.Core.Extension.Utils
{
    public static class HttpClientManager
    {
        /// <summary>
        /// url编码
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string UrlEncode(this string url)
        {
           
            return HttpUtility.UrlEncode(url);
        }
        /// <summary>
        /// url解码
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string UrlDecode(this string url)
        {
            return HttpUtility.UrlDecode(url);
        }
        /// <summary>
        /// 发送POST请求
        /// </summary>
        /// <param name="url"></param>
        /// <param name="postDataStr"></param>
        /// <returns></returns>
        public static string HttpPost(string url, string postDataStr="")
        {
            Encoding encoding = Encoding.GetEncoding("utf-8");
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "post";
            request.Accept = "text/html, application/xhtml+xml,application/x-www-form-urlencoded, */*";
            request.ContentType = "application/x-www-form-urlencoded";
            byte[] buffer = encoding.GetBytes(postDataStr);
            request.ContentLength = buffer.Length;
            request.GetRequestStream().Write(buffer, 0, buffer.Length);
            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            using (StreamReader reader = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding("utf-8")))

            {
                return reader.ReadToEnd();

            }
        }

        /// <summary>
        /// 发送GET请求，获取返回的信息
        /// </summary>
        /// <param name="url">url</param>
        /// <param name="timeout">超时时间</param>
        /// <returns></returns>
        public static string HttpGet(string url, int timeout = 60000)
        {
            if (string.IsNullOrEmpty(url)) return "none";

            var request = WebRequest.Create(url);
            request.Method = "GET";
            request.ContentType = "application/x-www-form-rulencoded;charset=utf8";
            request.Timeout = timeout;

            try
            {
                var response = request.GetResponse();
                using (var stream = new StreamReader(response.GetResponseStream(), Encoding.UTF8))
                {
                    return stream.ReadToEnd();
                }
            }
            catch (Exception)
            {
                return string.Empty;
            }
        }

        //private static readonly ILog Logger = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
        /// <summary>
        /// HttpClient实现Post请求
        /// </summary>
        /// <typeparam name="T1">传入对象类型</typeparam>
        /// <typeparam name="T2">返回对象类型</typeparam>
        /// <param name="url"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static async System.Threading.Tasks.Task<T2> PostAsync<T1, T2>(string url, T1 content) where T2 : new()
        {
            if (string.IsNullOrWhiteSpace(url) || content == null)
            {
                return new T2();
            }
            try
            {
                //设置内容压缩
                var handler = new HttpClientHandler() { AutomaticDecompression = DecompressionMethods.GZip };
                using (var client = new HttpClient(handler))
                {

                    client.DefaultRequestHeaders.Accept.Clear();
                    client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                    var postDataJson = JsonConvert.SerializeObject(content, new JsonSerializerSettings()
                    {
                        ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                        NullValueHandling = NullValueHandling.Ignore
                    });

                    var response = await client.PostAsync(url, new StringContent(postDataJson, Encoding.UTF8, "application/json"));
                    //var response = client.PostAsJsonAsync<T1>(url, content).Result;
                    if (response.IsSuccessStatusCode)
                    {
                        var reponseResult = response.Content.ReadAsStringAsync().Result;
                        var result = JsonConvert.DeserializeObject<T2>(reponseResult, new JsonSerializerSettings()
                        {
                            ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                            NullValueHandling = NullValueHandling.Ignore
                        });

                        return result;
                    }
                    return JsonConvert.DeserializeObject<T2>(null, new JsonSerializerSettings()
                    {
                        ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                        NullValueHandling = NullValueHandling.Ignore
                    });
                    //return new T2() { Message = "HTTP响应失败", };
                }
            }
            catch (Exception ex)
            {
                //LogHelper.WriteLog("post请求失败：" + url + "\r\n" + ex.Message + "\r\n" + ex.StackTrace);
                throw ex;
            }
        }

        /// <summary>
        /// HttpClient实现Post请求
        /// </summary>
        /// <param name="url"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string PostHttpAsync(string url,string content)
        {
            if (string.IsNullOrWhiteSpace(url) || content == null)
            {
                return string.Empty;
            }
            try
            {
                //设置内容压缩
                var handler = new HttpClientHandler() { AutomaticDecompression = DecompressionMethods.GZip };
                using (var client = new HttpClient(handler))
                {
                    client.DefaultRequestHeaders.Accept.Clear();
                    client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                   
                    var response = client.PostAsync(url, new StringContent(content, Encoding.UTF8, "application/json")).Result;
                    //var response = client.PostAsJsonAsync<T1>(url, content).Result;
                    if (response.IsSuccessStatusCode)
                    {
                        var reponseResult = response.Content.ReadAsStringAsync().Result;
                        if (string.IsNullOrWhiteSpace(reponseResult))
                        {
                            return string.Empty;
                        }
                        return reponseResult;
                    }
                    return JsonConvert.DeserializeObject<string>(null, new JsonSerializerSettings()
                    {
                        ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                        NullValueHandling = NullValueHandling.Ignore
                    });
                }
            }
            catch (Exception ex)
            {
                return $"异常：{ex.Message},堆栈信息:{ex.StackTrace}";
            }
        }

        /// <summary>
        /// HttpClient实现Post请求
        /// </summary>
        /// <typeparam name="T1">传入对象类型</typeparam>
        /// <param name="url"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static string PostHttpAsync<T1>(string url, T1 content)
        {
            if (string.IsNullOrWhiteSpace(url) || content == null)
            {
                return string.Empty;
            }
            try
            {
                //设置内容压缩
                var handler = new HttpClientHandler() { AutomaticDecompression = DecompressionMethods.GZip };
                using (var client = new HttpClient(handler))
                {
                    client.DefaultRequestHeaders.Accept.Clear();
                    client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                    var postDataJson = JsonConvert.SerializeObject(content, new JsonSerializerSettings()
                    {
                        ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                        NullValueHandling = NullValueHandling.Ignore
                    });
                    var response = client.PostAsync(url, new StringContent(postDataJson, Encoding.UTF8, "application/json")).Result;
                    //var response = client.PostAsJsonAsync<T1>(url, content).Result;
                    if (response.IsSuccessStatusCode)
                    {
                        var reponseResult = response.Content.ReadAsStringAsync().Result;
                        if (string.IsNullOrWhiteSpace(reponseResult))
                        {
                            return string.Empty;
                        }
                        return reponseResult;
                    }
                    return JsonConvert.DeserializeObject<string>(null, new JsonSerializerSettings()
                    {
                        ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                        NullValueHandling = NullValueHandling.Ignore
                    });
                    //return new T2() { Message = "HTTP响应失败", };
                }
            }
            catch (Exception ex)
            {
                return $"异常：{ex.Message},堆栈信息:{ex.StackTrace}";
            }
        }
    }
}
