﻿using System;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;

/****************************************************************
*   作者：tianzh
*   创建时间：2016/12/14 15:46:57
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/
namespace Bailun.Core.Extension.Utils
{
    /// <summary>
    /// csv操作类
    /// </summary>
    public class CsvFileHelper
    {
        /// <summary>
        /// 将DataTable中数据写入到CSV文件中
        /// </summary>
        /// <param name="dt">提供保存数据的DataTable</param>
        /// <param name="fileName">CSV的文件路径</param>
        public static void SaveCSV(DataTable dt, string fullPath)
        {
            FileInfo fi = new FileInfo(fullPath);
            if (!fi.Directory.Exists)
            {
                fi.Directory.Create();
            }
            FileStream fs = new FileStream(fullPath, System.IO.FileMode.Create, System.IO.FileAccess.Write);
            //StreamWriter sw = new StreamWriter(fs, System.Text.Encoding.Default);
            StreamWriter sw = new StreamWriter(fs, System.Text.Encoding.UTF8);
            string data = "";
            //写出列名称
            for (int i = 0; i < dt.Columns.Count; i++)
            {
                data += dt.Columns[i].ColumnName.ToString();
                if (i < dt.Columns.Count - 1)
                {
                    data += ",";
                }
            }
            sw.WriteLine(data);
            //写出各行数据
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                data = "";
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    string str = dt.Rows[i][j].ToString();
                    str = str.Replace("\"", "\"\"");//替换英文冒号 英文冒号需要换成两个冒号
                    if (str.Contains(',') || str.Contains('"')
                        || str.Contains('\r') || str.Contains('\n')) //含逗号 冒号 换行符的需要放到引号中
                    {
                        str = string.Format("\"{0}\"", str);
                    }

                    data += str;
                    if (j < dt.Columns.Count - 1)
                    {
                        data += ",";
                    }
                }
                sw.WriteLine(data);
            }
            sw.Close();
            fs.Close();
            //DialogResult result = MessageBox.Show("CSV文件保存成功！");
            //if (result == DialogResult.OK)
            //{
            //    System.Diagnostics.Process.Start("explorer.exe", Common.PATH_LANG);
            //}
        }

        /// <summary>
        /// 初始化导出过去30天有售出的listing表格
        /// </summary>
        /// <returns></returns>
        public static DataTable InitHaveSelling30DaysCsvDataTable(string fileName)
        {
            DataTable dt = new DataTable("proCategorysDatable" + Guid.NewGuid());
            dt.CaseSensitive = true;
            dt.Columns.Add("ListingId", Type.GetType("System.String"));
            dt.Columns.Add("Site", Type.GetType("System.String"));
            dt.Columns.Add("Category", Type.GetType("System.String"));
            dt.Columns.Add("SKU", Type.GetType("System.String"));
            dt.Columns.Add("group_id", Type.GetType("System.String"));
            dt.Columns.Add("QuantitySold", Type.GetType("System.Double"));
            dt.Columns.Add("enable", Type.GetType("System.Boolean"));
            dt.Columns.Add("stock", Type.GetType("System.Int32"));
            dt.Columns.Add("name", Type.GetType("System.String"));
            dt.Columns.Add("price", Type.GetType("System.Double"));
            dt.Columns.Add("old_price", Type.GetType("System.Double"));
            dt.Columns.Add("attrName1", Type.GetType("System.String"));
            dt.Columns.Add("attrValue1", Type.GetType("System.String"));
            dt.Columns.Add("attrName2", Type.GetType("System.String"));
            dt.Columns.Add("attrValue2", Type.GetType("System.String"));
            dt.Columns.Add("attrName3", Type.GetType("System.String"));
            dt.Columns.Add("attrValue3", Type.GetType("System.String"));
            dt.Columns.Add("weight", Type.GetType("System.String"));
            dt.Columns.Add("packaging_size", Type.GetType("System.String"));
            dt.Columns.Add("brand", Type.GetType("System.String"));
            dt.Columns.Add("tags", Type.GetType("System.String"));
            dt.Columns.Add("upc", Type.GetType("System.String"));
            dt.Columns.Add("description", Type.GetType("System.String"));
            dt.Columns.Add("main_image_url", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_1", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_2", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_3", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_4", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_5", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_6", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_7", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_8", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_9", Type.GetType("System.String"));
            dt.Columns.Add("Extra_Image_URL_10", Type.GetType("System.String"));
            dt.Columns.Add("shipping_template_id", Type.GetType("System.String"));
            dt.Columns.Add("shipping_time", Type.GetType("System.Int32"));
            dt.Columns.Add("langing_page_url", Type.GetType("System.String"));

            StreamWriter sw = new StreamWriter(fileName, true);
            string data = "";
            //写出列名称
            for (int i = 0; i < dt.Columns.Count; i++)
            {
                data += dt.Columns[i].ColumnName.ToString();
                if (i < dt.Columns.Count - 1)
                {
                    data += ",";
                }
            }
            sw.WriteLine(data);
            sw.Close();
            return dt;
        }

        /// <summary>
        /// 将DataTable中数据写入到CSV文件中
        /// </summary>
        /// <param name="dt">提供保存数据的DataTable</param>
        /// <param name="fullPath">CSV的文件路径</param>
        public static void SaveCSVWithAppend(DataTable dt, string fullPath,int count)
        {
            FileInfo fi = new FileInfo(fullPath);
            if (!fi.Directory.Exists)
            {
                fi.Directory.Create();
            }
            if (fi.Length /1024/1024 >= 100)//如果文件大小大于100M，新建文件
            {
                count++;
                fullPath = fullPath.Split('.')[0] + count + ".csv";
                InitHaveSelling30DaysCsvDataTable(fullPath);
            }
            //FileStream fs = new FileStream(fullPath, System.IO.FileMode.Create, System.IO.FileAccess.Write);
            //StreamWriter sw = new StreamWriter(fs, System.Text.Encoding.Default);
            //StreamWriter sw = new StreamWriter(fs, System.Text.Encoding.UTF8);
            StreamWriter sw = new StreamWriter(fullPath, true);
            string data = "";
            /*
            //写出列名称
            for (int i = 0; i < dt.Columns.Count; i++)
            {
                data += dt.Columns[i].ColumnName.ToString();
                if (i < dt.Columns.Count - 1)
                {
                    data += ",";
                }
            }
            sw.WriteLine(data);
            */
            //写出各行数据
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                data = "";
                for (int j = 0; j < dt.Columns.Count; j++)
                {
                    string str = dt.Rows[i][j].ToString();
                    str = str.Replace("\"", "\"\"");//替换英文冒号 英文冒号需要换成两个冒号
                    if (str.Contains(',') || str.Contains('"')
                        || str.Contains('\r') || str.Contains('\n')) //含逗号 冒号 换行符的需要放到引号中
                    {
                        str = string.Format("\"{0}\"", str);
                    }

                    data += str;
                    if (j < dt.Columns.Count - 1)
                    {
                        data += ",";
                    }
                }
                sw.WriteLine(data);
            }
            sw.Close();
            //fs.Close();
            //DialogResult result = MessageBox.Show("CSV文件保存成功！");
            //if (result == DialogResult.OK)
            //{
            //    System.Diagnostics.Process.Start("explorer.exe", Common.PATH_LANG);
            //}
        }



        /// <summary>
        /// 将CSV文件的数据读取到DataTable中
        /// </summary>
        /// <param name="fileName">CSV文件路径</param>
        /// <returns>返回读取了CSV数据的DataTable</returns>
        public static DataTable OpenCSV(string filePath)
        {
            Encoding encoding = Encoding.UTF8; //Encoding.ASCII;//
            DataTable dt = new DataTable();
            FileStream fs = new FileStream(filePath, System.IO.FileMode.Open, System.IO.FileAccess.Read);

            //StreamReader sr = new StreamReader(fs, Encoding.UTF8);
            StreamReader sr = new StreamReader(fs, encoding);
            //string fileContent = sr.ReadToEnd();
            //encoding = sr.CurrentEncoding;
            //记录每次读取的一行记录
            string strLine = "";
            //记录每行记录中的各字段内容
            string[] aryLine = null;
            string[] tableHead = null;
            //标示列数
            int columnCount = 0;
            //标示是否是读取的第一行
            bool IsFirst = true;
            //逐行读取CSV中的数据
            while ((strLine = sr.ReadLine()) != null)
            {
                //strLine = Common.ConvertStringUTF8(strLine, encoding);
                //strLine = Common.ConvertStringUTF8(strLine);

                if (IsFirst == true)
                {
                    tableHead = strLine.Split(',');
                    IsFirst = false;
                    columnCount = tableHead.Length;
                    //创建列
                    for (int i = 0; i < columnCount; i++)
                    {
                        DataColumn dc = new DataColumn(tableHead[i]);
                        dt.Columns.Add(dc);
                    }
                }
                else
                {
                    aryLine = strLine.Split(',');
                    DataRow dr = dt.NewRow();
                    for (int j = 0; j < columnCount; j++)
                    {
                        dr[j] = aryLine[j];
                    }
                    dt.Rows.Add(dr);
                }
            }
            if (aryLine != null && aryLine.Length > 0)
            {
                dt.DefaultView.Sort = tableHead[0] + " " + "asc";
            }

            sr.Close();
            fs.Close();
            return dt;
        }
    }
}
