﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Bailun.Core.Extension.Json;
using Bailun.Core.Extension.Utils;
using Newtonsoft.Json;

/****************************************************************
*   作者：tianzh
*   创建时间：2017/12/4 11:11:19
*   描述说明：
*
*   修改历史：
*
*
*****************************************************************/
namespace Bailun.Core.Extension.Translate
{
    public class TranslateInput
    {
        public string Qrery { get; set; }
        public string From { get; set; }
        public string To { get; set; }

    }
    public class GoogleTranslateResult
    {
        [JsonProperty("code")]
       public int Code { get; set; }
        [JsonProperty("data")]
        public List<string> Data { get; set; }
        [JsonProperty("msg")]
        public string Msg { get; set; }
    }
    /// <summary>
    /// 翻译model
    /// </summary>
    public class TranslateModel
    {
        /// <summary>
        /// 源语种
        /// </summary>
        [JsonProperty("from")]
        public string From { get; set; }
        /// <summary>
        /// 目标语种
        /// </summary>
        [JsonProperty("to")]
        public string To { get; set; }
        /// <summary>
        /// 翻译结果
        /// </summary>
        [JsonProperty("trans_result")]
        public List<TranslateResult> TranslateResult { get; set; }
    }
    /// <summary>
    /// 翻译结果
    /// </summary>
    public class TranslateResult
    {
        /// <summary>
        /// 源
        /// </summary>
        [JsonProperty("src")]
        public string Src { get; set; }
        /// <summary>
        /// 目标
        /// </summary>
        [JsonProperty("dst")]
        public string Dst { get; set; }
    }

    /// <summary>
    /// 翻译API
    /// </summary>
   public class TranslateHelper
    {
        /// <summary>
        /// 百度翻译API
        /// </summary>
        /// <param name="q">多个查询条件(用\n换行符分割)</param>
        /// <param name="from"></param>
        /// <param name="to"></param>
        /// <returns>{"from":"en","to":"zh","trans_result":[{"src":"apple","dst":"\u82f9\u679c"},{"src":"bear","dst":"\u718a"},{"src":"iphone","dst":"\u82f9\u679c\u624b\u673a"}]}</returns>
        public static TranslateModel TranslateByBaidu(string q, string from, string to)
        {
            var appId = "20170925000085060";
            var key = "SDYNa3LV_zdU8S9gWCjS";
            var salt = DateTime.Now.Ticks;
            var input = appId + q + salt + key;
            var url = "http://api.fanyi.baidu.com/api/trans/vip/translate";
            var sign = MD5Helper.GetMd5HashLower(input);
            var result = HttpClientManager.HttpPost(url, 
                 $"q={HttpUtility.UrlEncode(q)}&appid={appId}&salt={salt}&from={from}&to={to}&sign={sign}");
            return JsonHelper.FromJson<TranslateModel>(result);
        }
        /// <summary>
        /// 用google翻译
        /// </summary>
        /// <param name="q"></param>
        /// <param name="from"></param>
        /// <param name="to"></param>
        /// <returns></returns>
        public static TranslateModel TranslateByGoogle(string q, string from, string to)
        {
            var translateModel = new TranslateModel();
            translateModel.From = from;
            translateModel.To = to;
            translateModel.TranslateResult = new List<TranslateResult>();
            var watch = TimeHelper.TimerStart();
            // var sources = q.Split('\n');
          
            var dstLan = "";
            switch(to)
            {
                case "zh":
                    dstLan = "zh-cn";
                    break;
                case "fra":
                    dstLan = "fr";
                    break;
                case "spa":
                    dstLan = "es";
                    break;
                default:
                    dstLan = to;
                    break;
            }
            var sources = q.Replace("%20", " ");
            sources = sources.Replace("%22", "\"");//将双引号替换为!号
            sources = sources.Replace('&', '^');//将符号&替换为^
            //如果字符串小于5000字节，则以数组形式直接翻译。
            var sourcesArr = sources.Split('\n').ToList();
            if (!sources.IsNullOrEmpty() && sourcesArr.Count<50) //批量翻译
            {
               
                //按数组翻译
                TranslateByArray(sourcesArr, dstLan, translateModel);
            }
            else   //按照50拆分，长字符串拆分成多个数组批量调用google翻译
            {
              
                var size = 50;
                var page = Math.Ceiling(sourcesArr.Count * 1.0 / size).ToInt32();
                for (var i = 0; i < page; i++)
                {
                    var takeCount = size;
                    if (i == page - 1)
                    {
                        takeCount = sourcesArr.Count - (i) * size;
                      
                    }
                    //每次取50个去翻译
                    var arr = sourcesArr.GetRange(i * size, takeCount);
                    TranslateByArray(arr, dstLan, translateModel);
                }
            }

            
             return translateModel;

        }
        /// <summary>
        /// 按数组翻译
        /// </summary>
        /// <param name="sourcesArr">源</param>
        /// <param name="dstLan">目标语言</param>
        /// <param name="translateModel">翻译Model</param>
        private static void TranslateByArray(List<string> sourcesArr, string dstLan, TranslateModel translateModel)
        {
            var url = $"http://104.217.128.26:15678/translate/google";

            //var result = HttpHelper.Request(url+ $"?dest={dstLan}&text={sources}");
            var result = HttpClientManager.HttpPost(url, 
                $"dest={dstLan}&text={sourcesArr.ToJson()}");
            var translateApiResult = JsonHelper.FromJson<GoogleTranslateResult>(result);
            if (translateApiResult != null && translateApiResult.Code == 0)
            {
                var dstArr = translateApiResult.Data;
                for (var i = 0; i < sourcesArr.Count; i++)
                {
                    if (!sourcesArr[i].IsNullOrEmpty() && dstArr?.Count > 0 && !dstArr[i].IsNullOrEmpty())
                    {
                        var translateResult = new TranslateResult();
                        translateResult.Src = sourcesArr[i].Replace('^','&');//将符号^替换回&
                        translateResult.Dst = dstArr[i].Replace('^', '&');

                        translateModel.TranslateResult.Add(translateResult);
                    }
                }
            }
        }
    }
}
