﻿using System.Collections;
using Newtonsoft.Json;

namespace Bailun.Core.Extension.Page.Jqgrid
{
    /// <summary>
    /// jqgrid分页返回值
    /// </summary>
    public class JqgridPageResult<TOutputList> where TOutputList : IList
    {
        [JsonProperty("total")]
        public long Total { get; set; }
        [JsonProperty("rows")]
        public TOutputList List { set; get; }

        [JsonProperty("page")]
        public int PageIndex { get; set; }

        [JsonProperty("records")]
        public long Records { get; set; }
        [JsonProperty("costtime")]
        public string CostTime { get; set; }
        /// <summary>
        /// 构造JqgridPageResult返回值
        /// </summary>
        /// <param name="total"></param>
        /// <param name="list"></param>
        /// <param name="pageIndex"></param>
        /// <param name="records"></param>
        /// <param name="cosTime"></param>
        /// <returns></returns>
        public JqgridPageResult<TOutputList> ToJqgridPageResult(long total, TOutputList list, int pageIndex,
            long records, string cosTime)
        {
            var data = new JqgridPageResult<TOutputList>()
            {
                Total = total,
                List = list,
                PageIndex = pageIndex,
                Records = records,
                CostTime = cosTime
            };
            return data;
        }
    }
}

